/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ssdump2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.spf4j.base.Methods;
import org.spf4j.base.avro.Converters;
import org.spf4j.base.avro.Method;
import org.spf4j.base.avro.StackSampleElement;
import org.spf4j.io.MemorizingBufferedInputStream;
import org.spf4j.stackmonitor.SampleNode;

@ParametersAreNonnullByDefault
public final class Converter {
    private Converter() {
    }

    public static String createLabeledSsdump2FileName(String baseFileName, String label) {
        try {
            String encoded = URLEncoder.encode(label, StandardCharsets.UTF_8.name());
            encoded = encoded.replace("_", "%5F");
            return baseFileName + '_' + encoded + ".ssdump2";
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Unable to encode: " + label, ex);
        }
    }

    public static String getLabelFromSsdump2FileName(String fileName) {
        int spext = fileName.lastIndexOf(".ssdump2");
        if (spext < 0) {
            throw new IllegalArgumentException("Invalid ssdump2 file name: " + fileName);
        }
        int grsIdx = fileName.lastIndexOf(95, spext);
        try {
            if (grsIdx < 0) {
                return URLDecoder.decode(fileName.substring(0, spext), StandardCharsets.UTF_8.name());
            }
            return URLDecoder.decode(fileName.substring(grsIdx + 1, spext), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Invalid ssdump2 file name: " + fileName, ex);
        }
    }

    public static SampleNode convert(Iterator<StackSampleElement> samples) {
        TIntObjectHashMap index = new TIntObjectHashMap();
        while (samples.hasNext()) {
            StackSampleElement asmp = samples.next();
            SampleNode sn = new SampleNode(asmp.getCount());
            SampleNode parent = (SampleNode)index.get(asmp.getParentId());
            if (parent != null) {
                Method m = asmp.getMethod();
                parent.put(m, sn);
            }
            index.put(asmp.getId(), (Object)sn);
        }
        return (SampleNode)index.get(0);
    }

    public static void save(File file, SampleNode collected) throws IOException {
        try (OutputStream bos = Converter.newOutputStream(file);){
            SpecificDatumWriter writer = new SpecificDatumWriter(StackSampleElement.getClassSchema());
            BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder(bos, null);
            Converters.convert(Methods.ROOT, collected, -1, 0, object -> {
                try {
                    writer.write(object, (Encoder)encoder);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
            encoder.flush();
        }
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public static SampleNode load(File file) throws IOException {
        try (InputStream fis = Converter.newInputStream(file);){
            SampleNode sampleNode = Converter.load(fis);
            return sampleNode;
        }
    }

    public static SampleNode load(@WillNotClose InputStream fis) throws IOException {
        try (MemorizingBufferedInputStream bis = new MemorizingBufferedInputStream(fis);){
            final PushbackInputStream pis = new PushbackInputStream(bis);
            final SpecificDatumReader reader = new SpecificDatumReader(StackSampleElement.getClassSchema());
            final BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder((InputStream)pis, null);
            SampleNode sampleNode = Converter.convert(new Iterator<StackSampleElement>(){

                @Override
                public boolean hasNext() {
                    try {
                        int read = pis.read();
                        pis.unread(read);
                        return read >= 0;
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }

                @Override
                @SuppressFBWarnings
                public StackSampleElement next() {
                    try {
                        return (StackSampleElement)reader.read(null, (Decoder)decoder);
                    }
                    catch (IOException ex) {
                        NoSuchElementException e = new NoSuchElementException();
                        e.addSuppressed(ex);
                        throw e;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            });
            return sampleNode;
        }
    }

    public static void saveLabeledDumps(File file, Map<String, SampleNode> pcollected) throws IOException {
        try (OutputStream bos = Converter.newOutputStream(file);){
            SpecificDatumWriter writer = new SpecificDatumWriter(StackSampleElement.SCHEMA$);
            BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder(bos, null);
            encoder.writeMapStart();
            Map<String, SampleNode> collected = pcollected.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (SampleNode)e.getValue()));
            encoder.setItemCount((long)collected.size());
            for (Map.Entry<String, SampleNode> entry : collected.entrySet()) {
                encoder.startItem();
                encoder.writeString(entry.getKey());
                encoder.writeArrayStart();
                Converters.convert(Methods.ROOT, entry.getValue(), -1, 0, object -> {
                    try {
                        encoder.setItemCount(1L);
                        encoder.startItem();
                        writer.write(object, (Encoder)encoder);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                });
                encoder.writeArrayEnd();
            }
            encoder.writeMapEnd();
            encoder.flush();
        }
    }

    private static OutputStream newOutputStream(File file) throws IOException {
        FilterOutputStream result = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
        if (file.getName().endsWith(".gz")) {
            try {
                result = new GZIPOutputStream(result);
            }
            catch (IOException | RuntimeException ex) {
                ((OutputStream)result).close();
                throw ex;
            }
        }
        return result;
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public static Map<String, SampleNode> loadLabeledDumps(File file) throws IOException {
        try (InputStream bis = Converter.newInputStream(file);){
            SpecificDatumReader reader = new SpecificDatumReader(StackSampleElement.SCHEMA$);
            BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder(bis, null);
            long nrItems = decoder.readMapStart();
            StackSampleElement asmp = new StackSampleElement();
            HashMap<String, SampleNode> result = new HashMap<String, SampleNode>((int)nrItems);
            while (nrItems > 0L) {
                int i = 0;
                while ((long)i < nrItems) {
                    String key = decoder.readString();
                    TIntObjectMap<SampleNode> index = Converter.loadSamples((Decoder)decoder, asmp, (SpecificDatumReader<StackSampleElement>)reader);
                    result.put(key, (SampleNode)index.get(0));
                    ++i;
                }
                nrItems = decoder.mapNext();
            }
            HashMap<String, SampleNode> hashMap = result;
            return hashMap;
        }
    }

    @SuppressFBWarnings(value={"OCP_OVERLY_CONCRETE_PARAMETER"})
    private static TIntObjectMap<SampleNode> loadSamples(Decoder decoder, StackSampleElement pasmp, SpecificDatumReader<StackSampleElement> reader) throws IOException {
        TIntObjectHashMap index = new TIntObjectHashMap();
        long nrArrayItems = decoder.readArrayStart();
        while (nrArrayItems > 0L) {
            int j = 0;
            while ((long)j < nrArrayItems) {
                StackSampleElement asmp = (StackSampleElement)reader.read((Object)pasmp, decoder);
                SampleNode sn = new SampleNode(asmp.getCount());
                SampleNode parent = (SampleNode)index.get(asmp.getParentId());
                if (parent != null) {
                    Method readMethod = asmp.getMethod();
                    Method m = new Method(readMethod.getDeclaringClass(), readMethod.getName());
                    parent.put(m, sn);
                }
                index.put(asmp.getId(), (Object)sn);
                ++j;
            }
            nrArrayItems = decoder.arrayNext();
        }
        return index;
    }

    public static void loadLabels(File file, Consumer<String> labalsConsumer) throws IOException {
        try (InputStream bis = Converter.newInputStream(file);){
            SpecificDatumReader reader = new SpecificDatumReader(StackSampleElement.SCHEMA$);
            BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder(bis, null);
            long nrItems = decoder.readMapStart();
            StackSampleElement asmp = new StackSampleElement();
            while (nrItems > 0L) {
                int i = 0;
                while ((long)i < nrItems) {
                    String key = decoder.readString();
                    labalsConsumer.accept(key);
                    Converter.skipDump((Decoder)decoder, (SpecificDatumReader<StackSampleElement>)reader, asmp);
                    ++i;
                }
                nrItems = decoder.mapNext();
            }
        }
    }

    @SuppressFBWarnings(value={"OCP_OVERLY_CONCRETE_PARAMETER"})
    private static void skipDump(Decoder decoder, SpecificDatumReader<StackSampleElement> reader, StackSampleElement asmp) throws IOException {
        long nrArrayItems = decoder.readArrayStart();
        while (nrArrayItems > 0L) {
            int j = 0;
            while ((long)j < nrArrayItems) {
                reader.read((Object)asmp, decoder);
                ++j;
            }
            nrArrayItems = decoder.arrayNext();
        }
    }

    @Nullable
    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public static SampleNode loadLabeledDump(File file, String label) throws IOException {
        try (InputStream bis = Converter.newInputStream(file);){
            SpecificDatumReader reader = new SpecificDatumReader(StackSampleElement.SCHEMA$);
            BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder(bis, null);
            long nrItems = decoder.readMapStart();
            StackSampleElement asmp = new StackSampleElement();
            while (nrItems > 0L) {
                int i = 0;
                while ((long)i < nrItems) {
                    String key = decoder.readString();
                    if (label.equals(key)) {
                        SampleNode sampleNode = (SampleNode)Converter.loadSamples((Decoder)decoder, asmp, (SpecificDatumReader<StackSampleElement>)reader).get(0);
                        return sampleNode;
                    }
                    Converter.skipDump((Decoder)decoder, (SpecificDatumReader<StackSampleElement>)reader, asmp);
                    ++i;
                }
                nrItems = decoder.mapNext();
            }
            SampleNode sampleNode = null;
            return sampleNode;
        }
    }

    private static InputStream newInputStream(File file) throws IOException {
        BufferedInputStream result = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        if (file.getName().endsWith(".gz")) {
            try {
                return new GZIPInputStream(result);
            }
            catch (IOException | RuntimeException ex) {
                ((InputStream)result).close();
                throw ex;
            }
        }
        return result;
    }
}

