/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.set.hash.THashSet;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.Runtime;
import org.spf4j.base.Threads;
import org.spf4j.stackmonitor.ISampler;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.StackCollector;
import org.spf4j.stackmonitor.StackCollectorImpl;

@ParametersAreNonnullByDefault
public final class FastStackCollector
implements ISampler {
    private static final int DEFAULT_MAX_NR_SAMPLED_THREADS = Integer.getInteger("spf4j.stackCollector.maxSampledThreads", 128);
    private static final String[] IGNORED_THREADS = new String[]{"Finalizer", "Signal Dispatcher", "Reference Handler", "Attach Listener", "VM JFR Buffer Thread", "DestroyJavaVM"};
    private final Predicate<Thread> threadFilter;
    private final StackCollector collector;
    private Thread[] requestFor = new Thread[0];
    private final int maxNrSampledThreads;

    public FastStackCollector(boolean collectForMain, String ... xtraIgnoredThreads) {
        this(false, collectForMain, xtraIgnoredThreads);
    }

    public FastStackCollector(boolean collectRunnableThreadsOnly, boolean collectForMain, String ... xtraIgnoredThreads) {
        this(collectRunnableThreadsOnly, collectForMain, Threads.EMPTY_ARRAY, xtraIgnoredThreads);
    }

    public FastStackCollector(boolean collectRunnableThreadsOnly, boolean collectForMain, Thread[] ignored, String ... xtraIgnoredThreads) {
        this(FastStackCollector.createNameBasedFilter(collectRunnableThreadsOnly, collectForMain, ignored, xtraIgnoredThreads), DEFAULT_MAX_NR_SAMPLED_THREADS);
    }

    public FastStackCollector(Predicate<Thread> threadFilter, int maxNrSampledThreads) {
        this.threadFilter = threadFilter;
        this.collector = new StackCollectorImpl();
        this.maxNrSampledThreads = maxNrSampledThreads;
    }

    public static Predicate<Thread> createNameBasedFilter(boolean collectRunnableThreadsOnly, boolean collectForMain, Thread[] ignored, String[] xtraIgnoredThreads) {
        THashSet ignoredThreadNames = new THashSet(Arrays.asList(IGNORED_THREADS));
        ignoredThreadNames.addAll(Arrays.asList(xtraIgnoredThreads));
        Predicate<Thread> result = new ThreadNamesPredicate((Set<String>)ignoredThreadNames);
        if (collectRunnableThreadsOnly) {
            result = result.or(t -> Thread.State.RUNNABLE != t.getState());
        }
        for (Thread th : ignored) {
            result = result.or(t -> t == th);
        }
        if (!collectForMain) {
            Thread mainThread = Runtime.getMainThread();
            result = result.or(t -> t == mainThread);
        }
        return result;
    }

    @Deprecated
    public static Thread[] getThreads() {
        return Threads.getThreads();
    }

    @Deprecated
    public static StackTraceElement[][] getStackTraces(Thread ... threads) {
        return Threads.getStackTraces(threads);
    }

    @Deprecated
    public static void dumpToPrintStream(PrintStream stream) {
        Threads.dumpToPrintStream(stream);
    }

    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
    public void sample() {
        Thread[] threads = Threads.getThreads();
        int nrThreads = Threads.randomFirst(this.maxNrSampledThreads, threads);
        if (this.requestFor.length < nrThreads) {
            this.requestFor = new Thread[nrThreads];
        }
        int j = 0;
        for (int i = 0; i < nrThreads; ++i) {
            Thread th = threads[i];
            if (this.threadFilter.test(th)) continue;
            this.requestFor[j++] = th;
        }
        Arrays.fill(this.requestFor, j, this.requestFor.length, null);
        StackTraceElement[][] stackDump = Threads.getStackTraces(this.requestFor);
        for (int i = 0; i < j; ++i) {
            StackTraceElement[] stackTrace = stackDump[i];
            if (stackTrace != null && stackTrace.length > 0) {
                this.collector.collect(stackTrace);
                continue;
            }
            this.collector.collect(new StackTraceElement[]{new StackTraceElement("Thread", this.requestFor[i].getName(), "", 0)});
        }
    }

    @Override
    public Map<String, SampleNode> getCollectionsAndReset() {
        SampleNode nodes = this.collector.getAndReset();
        return nodes == null ? Collections.EMPTY_MAP : ImmutableMap.of((Object)"ALL", (Object)nodes);
    }

    @Override
    public Map<String, SampleNode> getCollections() {
        SampleNode nodes = this.collector.get();
        return nodes == null ? Collections.EMPTY_MAP : ImmutableMap.of((Object)"ALL", (Object)nodes);
    }

    public String toString() {
        return "FastStackCollector{threadFilter=" + this.threadFilter + ", collector=" + this.collector + '}';
    }

    public static final class ThreadNamesPredicate
    implements Predicate<Thread> {
        private final Set<String> ignoredThreadNames;

        public ThreadNamesPredicate(Set<String> ignoredThreadNames) {
            this.ignoredThreadNames = ignoredThreadNames;
        }

        @Override
        public boolean test(@Nonnull Thread input) {
            return this.ignoredThreadNames.contains(input.getName());
        }
    }
}

