/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import javax.annotation.Nullable;
import org.spf4j.stackmonitor.SampleNode;

public final class GCFakeStackUtil {
    private static final StackTraceElement[] GC_FAKE_STACK = new StackTraceElement[]{new StackTraceElement("java.lang.System", "gc", "System.java", -1)};

    private GCFakeStackUtil() {
    }

    @Nullable
    public static SampleNode createFakeGCSamples(long prevGCTimeMillis, long gcTimeMillis, long stMs) {
        if (gcTimeMillis > prevGCTimeMillis) {
            int fakeSamples = (int)((gcTimeMillis - prevGCTimeMillis) / stMs);
            if (fakeSamples > 0) {
                SampleNode node = SampleNode.createSampleNode(GC_FAKE_STACK);
                for (int i = 0; i < fakeSamples; ++i) {
                    SampleNode.addToSampleNode(node, GC_FAKE_STACK);
                }
                return node;
            }
            return null;
        }
        return null;
    }
}

