/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.SysExits;
import org.spf4j.stackmonitor.FastStackCollector;
import org.spf4j.stackmonitor.Sampler;

public final class Monitor {
    private Monitor() {
    }

    public static void main(String[] args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String[] ownArgs;
        String[] newArgs;
        int sepPos = args.length;
        for (int i = 0; i < args.length; ++i) {
            if (!"--".equals(args[i])) continue;
            sepPos = i;
            break;
        }
        if (sepPos == args.length) {
            newArgs = new String[]{};
            ownArgs = args;
        } else {
            newArgs = new String[args.length - sepPos - 1];
            ownArgs = new String[sepPos];
            System.arraycopy(args, sepPos + 1, newArgs, 0, newArgs.length);
            System.arraycopy(args, 0, ownArgs, 0, sepPos);
        }
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(ownArgs);
        }
        catch (CmdLineException e) {
            System.err.println("Error: " + e.getMessage() + "\nUsage:");
            parser.printUsage((OutputStream)System.err);
            System.exit(SysExits.EX_USAGE.exitCode());
        }
        final Sampler sampler = new Sampler(options.sampleInterval, options.dumpInterval, t -> new FastStackCollector(false, true, new Thread[]{t}, new String[0]), options.dumpFolder, options.dumpFilePrefix);
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new AbstractRunnable(){

            @Override
            public void doRun() throws InterruptedException, IOException {
                sampler.stop();
                sampler.dumpToFile();
                sampler.dispose();
            }
        }, "Sampling report"));
        sampler.registerJmx();
        if (options.startSampler) {
            sampler.start();
        }
        Class.forName(options.mainClass).getMethod("main", String[].class).invoke(null, new Object[]{newArgs});
        System.exit(SysExits.OK.exitCode());
    }

    private static class Options {
        @Option(name="-df", usage="dump folder")
        private String dumpFolder = Sampler.DEFAULT_SS_DUMP_FOLDER;
        @Option(name="-dp", usage="dump file prefix")
        private String dumpFilePrefix = Sampler.DEFAULT_SS_DUMP_FILE_NAME_PREFIX;
        @Option(name="-main", usage="the main class name", required=true)
        private String mainClass;
        @Option(name="-si", usage="the stack sampling interval in milliseconds")
        private int sampleInterval = 100;
        @Option(name="-di", usage="the stack dump to file interval in milliseconds")
        private int dumpInterval = 3600000;
        @Option(name="-ss", usage="start the stack sampling. (can also be done manually via jmx)")
        private boolean startSampler = false;

        private Options() {
        }
    }
}

