/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import com.google.common.collect.ImmutableMap;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.Map;
import org.spf4j.stackmonitor.ISampler;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.StackCollector;
import org.spf4j.stackmonitor.StackCollectorImpl;

public final class MxStackCollector
implements ISampler {
    private static final ThreadMXBean THREAD_MX = ManagementFactory.getThreadMXBean();
    private final Thread ignore;
    private final StackCollector collector;

    public MxStackCollector(Thread ignore) {
        this.ignore = ignore;
        this.collector = new StackCollectorImpl();
    }

    @Override
    public void sample() {
        ThreadInfo[] stackDump = THREAD_MX.dumpAllThreads(false, false);
        this.recordStackDump(stackDump);
    }

    private void recordStackDump(ThreadInfo[] stackDump) {
        long id = this.ignore.getId();
        for (ThreadInfo entry : stackDump) {
            StackTraceElement[] stackTrace = entry.getStackTrace();
            if (stackTrace.length <= 0 || entry.getThreadId() == id) continue;
            this.collector.collect(stackTrace);
        }
    }

    @Override
    public Map<String, SampleNode> getCollectionsAndReset() {
        SampleNode nodes = this.collector.getAndReset();
        return nodes == null ? Collections.EMPTY_MAP : ImmutableMap.of((Object)"ALL", (Object)nodes);
    }

    @Override
    public Map<String, SampleNode> getCollections() {
        SampleNode nodes = this.collector.get();
        return nodes == null ? Collections.EMPTY_MAP : ImmutableMap.of((Object)"ALL", (Object)nodes);
    }

    public String toString() {
        return "MxStackCollector{ignore=" + this.ignore + ", collector=" + this.collector + '}';
    }
}

