/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import javax.annotation.Nullable;
import org.spf4j.base.BasicExecutionContext;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.StackSamples;
import org.spf4j.stackmonitor.SampleNode;

public final class ProfiledExecutionContext
extends BasicExecutionContext {
    private SampleNode sampleNode = null;
    private final Object sync = new Object();

    public ProfiledExecutionContext(String name, CharSequence id, ExecutionContext parent, ExecutionContext.Relation relation, long startTimeNanos, long deadlineNanos) {
        super(name, id, parent, relation, startTimeNanos, deadlineNanos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SampleNode getAndClearStackSamples() {
        Object object = this.sync;
        synchronized (object) {
            SampleNode result = this.sampleNode;
            this.sampleNode = null;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StackSamples getStackSamples() {
        Object object = this.sync;
        synchronized (object) {
            if (this.sampleNode == null) {
                return null;
            }
            return SampleNode.clone(this.sampleNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(StackTraceElement[] sample) {
        Object object = this.sync;
        synchronized (object) {
            if (this.sampleNode == null) {
                this.sampleNode = SampleNode.createSampleNode(sample);
            } else {
                SampleNode.addToSampleNode(this.sampleNode, sample);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(StackSamples samples) {
        Object object = this.sync;
        synchronized (object) {
            if (this.sampleNode == null) {
                this.sampleNode = (SampleNode)samples;
            } else {
                this.sampleNode.add((SampleNode)samples);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (!this.isClosed()) {
            super.close();
            Object object = this.sync;
            synchronized (object) {
                ExecutionContext notClosedParent;
                if (this.sampleNode != null && (notClosedParent = this.getNotClosedParent()) != null) {
                    notClosedParent.add(this.sampleNode);
                }
            }
        }
    }
}

