/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.ThreadLocalContextAttacher;

@ParametersAreNonnullByDefault
public final class ProfilingTLAttacher
implements ThreadLocalContextAttacher {
    private final ConcurrentMap<Thread, ExecutionContext> currentContexts = Boolean.getBoolean("spf4j.ctxtProfiler.regDs.skipList") ? new ConcurrentSkipListMap(ProfilingTLAttacher::compare) : new ConcurrentHashMap(Integer.getInteger("spf4j.ctxtProfiler.regDs.concMap.initialSize", 64), Float.parseFloat(System.getProperty("spf4j.ctxtProfiler.regDs.concMap.loadFactor", "0.8")), Integer.getInteger("spf4j.ctxtProfiler.regDs.concMap.concurrencyLevel", 32));

    private static int compare(Thread o1, Thread o2) {
        return Long.compare(o1.getId(), o2.getId());
    }

    public Iterable<Thread> getCurrentThreads() {
        return this.currentContexts.keySet();
    }

    public Iterable<Map.Entry<Thread, ExecutionContext>> getCurrentThreadContexts() {
        return this.currentContexts.entrySet();
    }

    @Override
    public ThreadLocalContextAttacher.Attached attach(ExecutionContext ctx) {
        final ThreadLocalContextAttacher.Attached attached = ExecutionContexts.defaultThreadLocalAttacher().attach(ctx);
        if (attached.isTopOfStack()) {
            this.currentContexts.put(attached.attachedThread(), ctx);
            return new ThreadLocalContextAttacher.Attached(){

                @Override
                public void detach() {
                    ProfilingTLAttacher.this.currentContexts.remove(attached.attachedThread());
                    attached.detach();
                }

                @Override
                public boolean isTopOfStack() {
                    return attached.isTopOfStack();
                }

                @Override
                public Thread attachedThread() {
                    return attached.attachedThread();
                }
            };
        }
        return attached;
    }

    public String toString() {
        return "ProfilingTLAttacher{currentContexts=" + this.currentContexts + '}';
    }
}

