/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.map.TMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;
import org.spf4j.base.Json;
import org.spf4j.base.Methods;
import org.spf4j.base.MutableHolder;
import org.spf4j.base.Pair;
import org.spf4j.base.StackSamples;
import org.spf4j.base.avro.Method;
import org.spf4j.stackmonitor.MethodMap;

@ParametersAreNonnullByDefault
public final class SampleNode
extends MethodMap<SampleNode>
implements Serializable,
StackSamples {
    private static final long serialVersionUID = 1L;
    private int sampleCount;

    public SampleNode(int count, int capacity) {
        super(capacity);
        this.sampleCount = count;
    }

    public SampleNode(int count) {
        super(0);
        this.sampleCount = count;
    }

    public SampleNode() {
        super(0);
        this.sampleCount = 0;
    }

    @VisibleForTesting
    void addToCount(int nr) {
        this.sampleCount += nr;
    }

    public static SampleNode createSampleNode(StackTraceElement ... stackTrace) {
        SampleNode result;
        SampleNode prevResult = result = new SampleNode(1);
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            StackTraceElement elem = stackTrace[i];
            SampleNode node = new SampleNode(1);
            prevResult.put(Methods.getMethod(elem), node);
            prevResult = node;
        }
        return result;
    }

    public static void addToSampleNode(SampleNode node, StackTraceElement ... stackTrace) {
        SampleNode prevResult = node;
        ++prevResult.sampleCount;
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            StackTraceElement elem = stackTrace[i];
            Method method = Methods.getMethod(elem);
            SampleNode nNode = (SampleNode)prevResult.get(method);
            if (nNode != null) {
                ++nNode.sampleCount;
            } else {
                nNode = new SampleNode(1);
                prevResult.put(method, nNode);
            }
            prevResult = nNode;
        }
    }

    public TMap<Method, SampleNode> getSubNodes() {
        return this;
    }

    public static SampleNode clone(SampleNode node) {
        Traverse t;
        if (node.isEmpty()) {
            return new SampleNode(node.sampleCount);
        }
        SampleNode result = new SampleNode(node.sampleCount, node.size());
        ArrayDeque traverse = new ArrayDeque();
        node.forEachEntry((a, b) -> {
            traverse.add(new Traverse(result, (Method)a, (SampleNode)b));
            return true;
        });
        while ((t = (Traverse)traverse.poll()) != null) {
            if (t.child.isEmpty()) {
                t.parent.put(t.method, new SampleNode(((Traverse)t).child.sampleCount));
                continue;
            }
            SampleNode nc = new SampleNode(((Traverse)t).child.sampleCount, t.child.size());
            t.parent.put(t.method, nc);
            t.child.forEachEntry((a, b) -> {
                traverse.add(new Traverse(nc, (Method)a, (SampleNode)b));
                return true;
            });
        }
        return result;
    }

    @Nullable
    public static SampleNode aggregateNullable(@Nullable SampleNode node1, @Nullable SampleNode node2) {
        if (node1 == null) {
            if (node2 == null) {
                return null;
            }
            return node2;
        }
        if (node2 == null) {
            return node1;
        }
        return SampleNode.aggregate(node1, node2);
    }

    public static SampleNode aggregate(SampleNode node1, SampleNode node2) {
        SampleNode result = new SampleNode(node1.sampleCount + node2.sampleCount, Math.max(node1.size(), node2.size()) + 1);
        node1.forEachEntry((m, n) -> {
            result.put(m, SampleNode.clone(n));
            return true;
        });
        node2.forEachEntry((m, n) -> {
            SampleNode xn = (SampleNode)result.get(m);
            if (xn == null) {
                result.put(m, SampleNode.clone(n));
            } else {
                xn.add(SampleNode.clone(n));
            }
            return true;
        });
        return result;
    }

    @Nullable
    @SuppressFBWarnings(value={"CFS_CONFUSING_FUNCTION_SEMANTICS"})
    public static SampleNode aggregateNullableUnsafe(@Nullable SampleNode node1, @Nullable SampleNode node2) {
        if (node1 == null) {
            if (node2 == null) {
                return null;
            }
            return node2;
        }
        if (node2 == null) {
            return node1;
        }
        node1.add(node2);
        return node1;
    }

    public void add(SampleNode other) {
        this.sampleCount += other.sampleCount;
        other.forEachEntry((m, b) -> {
            SampleNode xChild = (SampleNode)this.get(m);
            if (xChild == null) {
                this.put(m, b);
            } else {
                xChild.add((SampleNode)b);
            }
            return true;
        });
    }

    @Override
    public int getSampleCount() {
        return this.sampleCount;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        this.writeTo(sb);
        return sb.toString();
    }

    public int height() {
        if (this.isEmpty()) {
            return 1;
        }
        int subHeight = 0;
        for (SampleNode node : this.values()) {
            int nHeight = node.height();
            if (nHeight <= subHeight) continue;
            subHeight = nHeight;
        }
        return subHeight + 1;
    }

    public int getNrNodes() {
        if (this.isEmpty()) {
            return 1;
        }
        int nrNodes = 0;
        for (SampleNode node : this.values()) {
            nrNodes += node.getNrNodes();
        }
        return nrNodes + 1;
    }

    @Nullable
    public SampleNode filteredBy(Predicate<Method> predicate) {
        int newCount = this.sampleCount;
        SampleNode result = new SampleNode(0);
        for (Map.Entry entry : this.entrySet()) {
            Method method = (Method)entry.getKey();
            SampleNode sn = (SampleNode)entry.getValue();
            if (predicate.test(method)) {
                newCount -= sn.getSampleCount();
                continue;
            }
            SampleNode sn2 = sn.filteredBy(predicate);
            if (sn2 == null) {
                newCount -= sn.getSampleCount();
                continue;
            }
            newCount -= sn.getSampleCount() - sn2.getSampleCount();
            result.put(method, sn2);
        }
        if (newCount == 0) {
            return null;
        }
        if (newCount < 0) {
            throw new IllegalStateException("child sample counts must be <= parent sample count, detail: " + this);
        }
        result.sampleCount = newCount;
        return result;
    }

    @Override
    public void writeJsonTo(Appendable appendable) throws IOException {
        this.writeTo(Methods.ROOT, appendable);
    }

    public void writeTo(Method m, Appendable appendable) throws IOException {
        ArrayDeque<Object> dq = new ArrayDeque<Object>();
        dq.add(Pair.of(m, this));
        while (!dq.isEmpty()) {
            Object obj = dq.removeLast();
            if (obj instanceof CharSequence) {
                appendable.append((CharSequence)obj);
                continue;
            }
            Map.Entry s = (Map.Entry)obj;
            appendable.append("{\"");
            Methods.writeTo((Method)s.getKey(), appendable);
            appendable.append("\":");
            SampleNode sn = (SampleNode)s.getValue();
            appendable.append(Integer.toString(sn.getSampleCount()));
            Iterator iterator = sn.entrySet().iterator();
            if (iterator.hasNext()) {
                appendable.append(",\"c\":[");
                dq.addLast("]}");
                dq.addLast(iterator.next());
                while (iterator.hasNext()) {
                    dq.addLast(",");
                    dq.addLast(iterator.next());
                }
                continue;
            }
            appendable.append('}');
        }
    }

    public void writeD3JsonTo(Appendable appendable) throws IOException {
        this.writeD3JsonFormatTo(Methods.ROOT, appendable);
    }

    public void writeD3JsonFormatTo(Method m, Appendable appendable) throws IOException {
        ArrayDeque<Object> dq = new ArrayDeque<Object>();
        dq.add(Pair.of(m, this));
        while (!dq.isEmpty()) {
            Object obj = dq.removeLast();
            if (obj instanceof CharSequence) {
                appendable.append((CharSequence)obj);
                continue;
            }
            Map.Entry s = (Map.Entry)obj;
            appendable.append("{\"name\":\"");
            Methods.writeTo((Method)s.getKey(), appendable);
            appendable.append("\",\"value\":");
            SampleNode sn = (SampleNode)s.getValue();
            appendable.append(Integer.toString(sn.getSampleCount()));
            Iterator iterator = sn.entrySet().iterator();
            if (iterator.hasNext()) {
                appendable.append(",\"children\":[");
                dq.addLast("]}");
                dq.addLast(iterator.next());
                while (iterator.hasNext()) {
                    dq.addLast(",");
                    dq.addLast(iterator.next());
                }
                continue;
            }
            appendable.append('}');
        }
    }

    public static void traverse(Method m, SampleNode node, Invocation handler) {
        SampleNode.traverse(m, node, handler, true);
    }

    public static void traverse(Method m, SampleNode node, Invocation handler, boolean breadthFirst) {
        SampleNode.traverse(m, node, handler, breadthFirst ? Deque::pollFirst : Deque::pollLast);
    }

    public static void traverse(Method m, SampleNode node, final Invocation handler, Function<Deque, TraversalData> func) {
        TraversalData t;
        final ArrayDeque<TraversalData> dq = new ArrayDeque<TraversalData>();
        dq.add(new TraversalData(m, node));
        while ((t = func.apply(dq)) != null) {
            if (t.n.isEmpty()) continue;
            final Method from = t.m;
            boolean conti = t.n.forEachEntry(new TObjectObjectProcedure<Method, SampleNode>(){

                public boolean execute(Method a, SampleNode b) {
                    boolean result = handler.invocation(from, a, b.sampleCount);
                    if (result) {
                        dq.addLast(new TraversalData(a, b));
                    }
                    return result;
                }
            });
            if (conti) continue;
            return;
        }
    }

    public static Pair<Method, SampleNode> parse(@WillNotClose Reader r) throws IOException {
        JsonParser jsonP = Json.FACTORY.createParser(r);
        SampleNode.consume(jsonP, JsonToken.START_OBJECT);
        MutableHolder.ComparableHolder<Object> method = MutableHolder.of(null);
        MutableHolder<SampleNode> samples = MutableHolder.of(null);
        SampleNode.parse(jsonP, (m, s) -> {
            method.setValue(m);
            samples.setValue((SampleNode)s);
        });
        return Pair.of(method.get(), samples.get());
    }

    private static void parse(JsonParser jsonP, BiConsumer<Method, SampleNode> consumer) throws IOException {
        SampleNode.consume(jsonP, JsonToken.FIELD_NAME);
        String name = jsonP.getCurrentName();
        SampleNode.consume(jsonP, JsonToken.VALUE_NUMBER_INT);
        int sc = jsonP.getIntValue();
        JsonToken nextToken = jsonP.nextToken();
        if (nextToken == JsonToken.END_OBJECT) {
            consumer.accept(Methods.from(name), new SampleNode(sc));
        } else if (nextToken == JsonToken.FIELD_NAME) {
            SampleNode.consume(jsonP, JsonToken.START_ARRAY);
            SampleNode sn = new SampleNode(sc);
            while (jsonP.nextToken() != JsonToken.END_ARRAY) {
                SampleNode.parse(jsonP, sn::put);
            }
            SampleNode.consume(jsonP, JsonToken.END_OBJECT);
            consumer.accept(Methods.from(name), sn);
        } else {
            throw new JsonParseException(jsonP, "Expected field name or end Object, not: " + nextToken);
        }
    }

    public static void parseInto(@WillNotClose Reader r, SampleNode root) throws IOException {
        JsonParser jsonP = Json.FACTORY.createParser(r);
        SampleNode.consume(jsonP, JsonToken.START_OBJECT);
        SampleNode sn = new SampleNode();
        sn.put(Methods.ROOT, root);
        SampleNode.parseInto(jsonP, sn);
    }

    public static void parseInto(JsonParser jsonP, SampleNode parentNode) throws IOException {
        SampleNode.consume(jsonP, JsonToken.FIELD_NAME);
        String name = jsonP.getCurrentName();
        SampleNode.consume(jsonP, JsonToken.VALUE_NUMBER_INT);
        int sc = jsonP.getIntValue();
        JsonToken nextToken = jsonP.nextToken();
        Method method = Methods.from(name);
        SampleNode sn = (SampleNode)parentNode.get(method);
        if (sn == null) {
            sn = new SampleNode(sc);
            parentNode.put(method, sn);
        } else {
            sn.sampleCount += sc;
        }
        if (nextToken == JsonToken.END_OBJECT) {
            return;
        }
        if (nextToken == JsonToken.FIELD_NAME) {
            SampleNode.consume(jsonP, JsonToken.START_ARRAY);
            while (jsonP.nextToken() != JsonToken.END_ARRAY) {
                SampleNode.parseInto(jsonP, sn);
            }
        } else {
            throw new JsonParseException(jsonP, "Expected field name or end Object, not: " + nextToken);
        }
        SampleNode.consume(jsonP, JsonToken.END_OBJECT);
    }

    public static Pair<Method, SampleNode> parseD3Json(@WillNotClose Reader r) throws IOException {
        JsonParser jsonP = Json.FACTORY.createParser(r);
        SampleNode.consume(jsonP, JsonToken.START_OBJECT);
        MutableHolder.ComparableHolder<Object> method = MutableHolder.of(null);
        MutableHolder<SampleNode> samples = MutableHolder.of(null);
        SampleNode.parseD3Json(jsonP, (m, s) -> {
            method.setValue(m);
            samples.setValue((SampleNode)s);
        });
        return Pair.of(method.get(), samples.get());
    }

    @SuppressFBWarnings(value={"WEM_WEAK_EXCEPTION_MESSAGING"})
    private static void parseD3Json(JsonParser jsonP, BiConsumer<Method, SampleNode> consumer) throws IOException {
        JsonToken nextToken;
        String methodName = null;
        SampleNode sn = new SampleNode(-1);
        block10: while ((nextToken = jsonP.nextToken()) == JsonToken.FIELD_NAME) {
            String fieldName;
            switch (fieldName = jsonP.getCurrentName()) {
                case "name": {
                    SampleNode.consume(jsonP, JsonToken.VALUE_STRING);
                    methodName = jsonP.getText();
                    break;
                }
                case "value": {
                    SampleNode.consume(jsonP, JsonToken.VALUE_NUMBER_INT);
                    sn.sampleCount = jsonP.getIntValue();
                    break;
                }
                case "children": {
                    SampleNode.consume(jsonP, JsonToken.START_ARRAY);
                    while (jsonP.nextToken() != JsonToken.END_ARRAY) {
                        SampleNode.parseD3Json(jsonP, sn::put);
                    }
                    continue block10;
                }
                default: {
                    throw new JsonParseException(jsonP, "Unexpected field name : " + fieldName);
                }
            }
        }
        if (nextToken == JsonToken.END_OBJECT) {
            if (methodName == null) {
                throw new JsonParseException(jsonP, "name field not found");
            }
            if (sn.sampleCount < 0) {
                throw new JsonParseException(jsonP, "value field not found");
            }
            consumer.accept(Methods.from(methodName), sn);
            return;
        }
        throw new JsonParseException(jsonP, "Unexpected " + nextToken);
    }

    private static void consume(JsonParser jsonP, JsonToken token) throws IOException {
        JsonToken nextToken = jsonP.nextToken();
        if (nextToken != token) {
            throw new JsonParseException(jsonP, "Expected start object, not " + nextToken);
        }
    }

    @Override
    public int hashCode() {
        return 89 * this.sampleCount + super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.sampleCount != ((SampleNode)obj).sampleCount) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.sampleCount);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sampleCount = in.readInt();
    }

    public static interface Invocation {
        @CheckReturnValue
        public boolean invocation(Method var1, Method var2, int var3);
    }

    private static final class TraversalData {
        private final Method m;
        private final SampleNode n;

        TraversalData(Method m, SampleNode n) {
            this.m = m;
            this.n = n;
        }
    }

    private static class Traverse {
        private final SampleNode parent;
        private final Method method;
        private final SampleNode child;

        Traverse(SampleNode parent, Method method, SampleNode child) {
            this.parent = parent;
            this.method = method;
            this.child = child;
        }
    }
}

