/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.CharSequences;
import org.spf4j.base.DateTimeFormats;
import org.spf4j.base.SuppressForbiden;
import org.spf4j.base.TimeSource;
import org.spf4j.base.Timing;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.ssdump2.Converter;
import org.spf4j.stackmonitor.FastStackCollector;
import org.spf4j.stackmonitor.ISampler;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.SamplerSupplier;
import org.spf4j.stackmonitor.Spf4jProfilerException;

@ThreadSafe
public final class Sampler {
    private static Sampler instance;
    public static final String DEFAULT_SS_DUMP_FOLDER;
    public static final String DEFAULT_SS_DUMP_FILE_NAME_PREFIX;
    @GuardedBy(value="sync")
    private boolean stopped;
    private volatile boolean compressDumps;
    private volatile long sampleTimeNanos;
    private volatile long dumpTimeNanos;
    private final SamplerSupplier stackCollectorSupp;
    private volatile long lastDumpTimeNanos;
    private final Object sync = new Object();
    @GuardedBy(value="sync")
    private ISampler stackCollector;
    @GuardedBy(value="sync")
    private Future<?> samplerFuture;
    private final String filePrefix;
    private final File dumpFolder;

    public String toString() {
        return "Sampler{stopped=" + this.stopped + ", sampleTimeNanos=" + this.sampleTimeNanos + ", dumpTimeNanos=" + this.dumpTimeNanos + ", lastDumpTimeNanos=" + this.lastDumpTimeNanos + ", dumpFolder=" + this.dumpFolder + ", filePrefix=" + this.filePrefix + '}';
    }

    public Sampler() {
        this(10, 3600000, t -> new FastStackCollector(false, true, new Thread[]{t}, new String[0]));
    }

    public Sampler(int sampleTimeMillis) {
        this(sampleTimeMillis, 3600000, t -> new FastStackCollector(false, true, new Thread[]{t}, new String[0]));
    }

    public Sampler(int sampleTimeMillis, SamplerSupplier collector) {
        this(sampleTimeMillis, 3600000, collector);
    }

    public Sampler(SamplerSupplier collector) {
        this(10, 3600000, collector);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public Sampler(int sampleTimeMillis, int dumpTimeMillis) {
        this(sampleTimeMillis, dumpTimeMillis, (Thread t) -> new FastStackCollector(false, true, new Thread[]{t}, new String[0]), DEFAULT_SS_DUMP_FOLDER, DEFAULT_SS_DUMP_FILE_NAME_PREFIX);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public Sampler(int sampleTimeMillis, int dumpTimeMillis, SamplerSupplier collector) {
        this(sampleTimeMillis, dumpTimeMillis, collector, DEFAULT_SS_DUMP_FOLDER, DEFAULT_SS_DUMP_FILE_NAME_PREFIX);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public Sampler(int sampleTimeMillis, int dumpTimeMillis, SamplerSupplier collector, String dumpFolder, String dumpFilePrefix) {
        this(sampleTimeMillis, dumpTimeMillis, collector, new File(dumpFolder), dumpFilePrefix);
    }

    public Sampler(int sampleTimeMillis, int dumpTimeMillis, SamplerSupplier collector, File dumpFolder, String dumpFilePrefix) {
        this(sampleTimeMillis, dumpTimeMillis, collector, dumpFolder, dumpFilePrefix, true);
    }

    public Sampler(int sampleTimeMillis, int dumpTimeMillis, SamplerSupplier collector, File dumpFolder, String dumpFilePrefix, boolean compressDumps) {
        CharSequences.validatedFileName(dumpFilePrefix);
        this.stopped = true;
        if (sampleTimeMillis < 1) {
            throw new IllegalArgumentException("Invalid sample time " + sampleTimeMillis);
        }
        this.sampleTimeNanos = TimeUnit.MILLISECONDS.toNanos(sampleTimeMillis);
        if (this.sampleTimeNanos < 0L) {
            throw new IllegalArgumentException("Invalid sample time " + sampleTimeMillis);
        }
        this.dumpTimeNanos = TimeUnit.MILLISECONDS.toNanos(dumpTimeMillis);
        this.stackCollectorSupp = collector;
        this.filePrefix = dumpFilePrefix;
        this.dumpFolder = dumpFolder;
        this.compressDumps = compressDumps;
    }

    public static synchronized Sampler getSampler(int sampleTimeMillis, int dumpTimeMillis, File dumpFolder, String dumpFilePrefix) throws InterruptedException {
        return Sampler.getSampler(sampleTimeMillis, dumpTimeMillis, t -> new FastStackCollector(false, true, new Thread[]{t}, new String[0]), dumpFolder, dumpFilePrefix);
    }

    public static synchronized Sampler getSampler(int sampleTimeMillis, int dumpTimeMillis, SamplerSupplier collector, File dumpFolder, String dumpFilePrefix) throws InterruptedException {
        if (instance == null) {
            try {
                instance = new Sampler(sampleTimeMillis, dumpTimeMillis, collector, dumpFolder.getCanonicalFile(), dumpFilePrefix);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            instance.registerJmx();
            return instance;
        }
        instance.dispose();
        try {
            instance = new Sampler(sampleTimeMillis, dumpTimeMillis, collector, dumpFolder.getCanonicalFile(), dumpFilePrefix);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        instance.registerJmx();
        return instance;
    }

    public void registerJmx() {
        Registry.export(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxExport(description="start stack sampling")
    public void start() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.stopped) {
                throw new IllegalStateException("Sampling can only be started once for " + this);
            }
            this.stopped = false;
            final long stNanos = this.sampleTimeNanos;
            this.samplerFuture = DefaultExecutor.INSTANCE.submit(new AbstractRunnable("SPF4J-Sampling-Thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @SuppressFBWarnings(value={"MDM_THREAD_YIELD", "PREDICTABLE_RANDOM"})
                public void doRun() {
                    Sampler.this.lastDumpTimeNanos = TimeSource.nanoTime();
                    Object object = Sampler.this.sync;
                    synchronized (object) {
                        Sampler.this.stackCollector = Sampler.this.stackCollectorSupp.get(Thread.currentThread());
                    }
                    long lDumpTimeNanos = Sampler.this.dumpTimeNanos;
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    long dumpCounterNanos = 0L;
                    long sleepTimeNanos = 0L;
                    long halfStNanos = stNanos / 2L;
                    if (halfStNanos == 0L) {
                        halfStNanos = 1L;
                    }
                    long maxSleeepNanos = stNanos + halfStNanos;
                    block9: while (true) {
                        try {
                            while (true) {
                                Object object2 = Sampler.this.sync;
                                synchronized (object2) {
                                    Sampler.this.stackCollector.sample();
                                    if (Sampler.this.stopped) {
                                        break block9;
                                    }
                                }
                                if ((dumpCounterNanos += sleepTimeNanos) >= lDumpTimeNanos) {
                                    long nanosSinceLastDump = TimeSource.nanoTime() - Sampler.this.lastDumpTimeNanos;
                                    if (nanosSinceLastDump >= lDumpTimeNanos) {
                                        dumpCounterNanos = 0L;
                                        File dumpFile = Sampler.this.dumpToFile();
                                        if (dumpFile != null) {
                                            Logger.getLogger(Sampler.class.getName()).log(Level.INFO, "Stack samples written to {0}", dumpFile);
                                        }
                                    } else {
                                        dumpCounterNanos = nanosSinceLastDump;
                                    }
                                }
                                sleepTimeNanos = random.nextLong(halfStNanos, maxSleeepNanos);
                                TimeUnit.NANOSECONDS.sleep(sleepTimeNanos);
                            }
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                        catch (IOException | RuntimeException ex) {
                            Logger.getLogger(Sampler.class.getName()).log(Level.SEVERE, "Exception encountered while samplig, will continue sampling", ex);
                            continue;
                        }
                        break;
                    }
                }
            });
        }
    }

    @JmxExport
    public boolean isCompressDumps() {
        return this.compressDumps;
    }

    @JmxExport
    public void setCompressDumps(boolean compressDumps) {
        this.compressDumps = compressDumps;
    }

    @JmxExport(description="save stack samples to file")
    @Nullable
    public File dumpToFile() throws IOException {
        return this.dumpToFile(null);
    }

    @JmxExport(value="dumpToSpecificFile", description="save stack samples to file")
    @Nullable
    public File dumpToFile(@JmxExport(value="fileID", description="the ID that will be part of the file name") @Nullable String id) throws IOException {
        String fileName = this.filePrefix + (id == null ? "" : '_' + id) + '_' + DateTimeFormats.COMPACT_TS_FORMAT.format(Timing.getCurrentTiming().fromNanoTimeToInstant(this.lastDumpTimeNanos)) + '_' + DateTimeFormats.COMPACT_TS_FORMAT.format(Instant.now());
        return this.dumpToFile(this.dumpFolder, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public File dumpToFile(@Nonnull File destinationFolder, String pbaseFileName) throws IOException {
        String newFileName;
        Map<String, SampleNode> collections;
        CharSequences.validatedFileName(pbaseFileName);
        String baseFileName = URLEncoder.encode(pbaseFileName, StandardCharsets.UTF_8.name());
        Object object = this.sync;
        synchronized (object) {
            if (this.stackCollector == null) {
                return null;
            }
            collections = this.stackCollector.getCollectionsAndReset();
            this.lastDumpTimeNanos = TimeSource.nanoTime();
        }
        if (collections.isEmpty()) {
            return null;
        }
        if (collections.size() == 1) {
            Map.Entry<String, SampleNode> es = collections.entrySet().iterator().next();
            SampleNode samples = es.getValue();
            if (samples == null) {
                return null;
            }
            newFileName = baseFileName.endsWith(".ssdump2") ? baseFileName : Converter.createLabeledSsdump2FileName(baseFileName, es.getKey());
            if (this.compressDumps) {
                newFileName = newFileName + ".gz";
            }
            File file = new File(destinationFolder, newFileName);
            Converter.save(file, samples);
            return file;
        }
        newFileName = baseFileName.endsWith(".ssdump3") ? baseFileName : baseFileName + ".ssdump3";
        if (this.compressDumps) {
            newFileName = newFileName + ".gz";
        }
        File file = new File(destinationFolder, newFileName);
        Converter.saveLabeledDumps(file, collections);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxExport(description="stop stack sampling")
    public void stop() throws InterruptedException {
        Future<?> toCancel = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.stopped) {
                this.stopped = true;
                toCancel = this.samplerFuture;
            }
        }
        if (toCancel != null) {
            try {
                toCancel.get(this.dumpTimeNanos * 3L, TimeUnit.NANOSECONDS);
            }
            catch (TimeoutException ex) {
                toCancel.cancel(true);
                throw new Spf4jProfilerException(ex);
            }
            catch (ExecutionException ex) {
                throw new Spf4jProfilerException(ex);
            }
        }
    }

    @JmxExport(description="stack sample time in milliseconds")
    public int getSampleTimeMillis() {
        return (int)TimeUnit.NANOSECONDS.toMillis(this.sampleTimeNanos);
    }

    @JmxExport
    public void setSampleTimeMillis(int sampleTimeMillis) {
        this.sampleTimeNanos = (int)TimeUnit.MILLISECONDS.toNanos(sampleTimeMillis);
    }

    @JmxExport(description="is the stack sampling stopped")
    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxExport(description="clear in memory collected stack samples")
    public void clear() {
        Object object = this.sync;
        synchronized (object) {
            this.stackCollector.getCollectionsAndReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SampleNode> getStackCollectionsAndReset() {
        Object object = this.sync;
        synchronized (object) {
            if (this.stackCollector == null) {
                return Collections.EMPTY_MAP;
            }
            return this.stackCollector.getCollectionsAndReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SampleNode> getStackCollections() {
        Object object = this.sync;
        synchronized (object) {
            if (this.stackCollector == null) {
                return Collections.EMPTY_MAP;
            }
            return this.stackCollector.getCollections();
        }
    }

    @PreDestroy
    public void dispose() throws InterruptedException {
        this.stop();
        Registry.unregister(this);
    }

    @JmxExport(description="interval in milliseconds to save stack stamples periodically")
    public int getDumpTimeMillis() {
        return (int)TimeUnit.NANOSECONDS.toMillis(this.dumpTimeNanos);
    }

    @JmxExport
    public void setDumpTimeMillis(int dumpTimeMillis) {
        this.dumpTimeNanos = TimeUnit.MILLISECONDS.toNanos(dumpTimeMillis);
    }

    @JmxExport
    public String getFilePrefix() {
        return this.filePrefix;
    }

    @JmxExport
    public String getDumpFolder() {
        return this.dumpFolder.toString();
    }

    @JmxExport
    @SuppressForbiden
    public Date getLastDumpTime() {
        return new Date(Timing.getCurrentTiming().fromNanoTimeToEpochMillis(this.lastDumpTimeNanos));
    }

    static {
        DEFAULT_SS_DUMP_FOLDER = System.getProperty("spf4j.perf.ms.defaultSsdumpFolder", System.getProperty("java.io.tmpdir"));
        DEFAULT_SS_DUMP_FILE_NAME_PREFIX = CharSequences.validatedFileName(System.getProperty("spf4j.perf.ms.defaultSsdumpFilePrefix", ManagementFactory.getRuntimeMXBean().getName()));
    }
}

