/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.spf4j.stackmonitor.ISampler;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.StackCollector;
import org.spf4j.stackmonitor.StackCollectorImpl;

public final class SimpleStackCollector
implements ISampler {
    private final Thread ignore;
    private final StackCollector collector;

    public SimpleStackCollector(Thread ignore) {
        this.ignore = ignore;
        this.collector = new StackCollectorImpl();
    }

    @Override
    public void sample() {
        Map<Thread, StackTraceElement[]> stackDump = Thread.getAllStackTraces();
        stackDump.remove(this.ignore);
        for (Map.Entry<Thread, StackTraceElement[]> element : stackDump.entrySet()) {
            StackTraceElement[] stackTrace = element.getValue();
            if (stackTrace.length > 0) {
                this.collector.collect(stackTrace);
                continue;
            }
            this.collector.collect(new StackTraceElement[]{new StackTraceElement("Thread", element.getKey().getName(), "", 0)});
        }
    }

    @Override
    public Map<String, SampleNode> getCollectionsAndReset() {
        SampleNode nodes = this.collector.getAndReset();
        return nodes == null ? Collections.EMPTY_MAP : ImmutableMap.of((Object)"ALL", (Object)nodes);
    }

    @Override
    public Map<String, SampleNode> getCollections() {
        SampleNode nodes = this.collector.get();
        return nodes == null ? Collections.EMPTY_MAP : ImmutableMap.of((Object)"ALL", (Object)nodes);
    }

    public String toString() {
        return "SimpleStackCollector{ignore=" + this.ignore + ", collector=" + this.collector + '}';
    }
}

