/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.StackCollector;

@NotThreadSafe
public final class StackCollectorImpl
implements StackCollector {
    private SampleNode samples;

    @Override
    @Nullable
    public SampleNode getAndReset() {
        SampleNode result = this.samples;
        this.samples = null;
        return result;
    }

    @Override
    @Nullable
    public SampleNode get() {
        if (this.samples == null) {
            return null;
        }
        return SampleNode.clone(this.samples);
    }

    @Override
    public void collect(StackTraceElement[] stackTrace) {
        if (this.samples == null) {
            this.samples = SampleNode.createSampleNode(stackTrace);
        } else {
            SampleNode.addToSampleNode(this.samples, stackTrace);
        }
    }

    public String toString() {
        return "AbstractStackCollector{samples=" + this.samples + '}';
    }

    public int getNrNodes() {
        if (this.samples == null) {
            return 0;
        }
        return this.samples.getNrNodes();
    }
}

