/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.PrimeFinder;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@SuppressFBWarnings
public abstract class THash
implements Externalizable {
    static final long serialVersionUID = -1792948471915530295L;
    protected static final float DEFAULT_LOAD_FACTOR = Float.parseFloat(System.getProperty("spf4j.methodMap.loadFactor", "0.7"));
    protected static final int DEFAULT_CAPACITY = 10;
    protected transient int _size;
    protected int _maxSize;

    public THash() {
        this(10);
    }

    public THash(int initialCapacity) {
        this.setUp(HashFunctions.fastCeil((float)((float)initialCapacity / DEFAULT_LOAD_FACTOR)));
    }

    public boolean isEmpty() {
        return 0 == this._size;
    }

    public int size() {
        return this._size;
    }

    public abstract int capacity();

    public void ensureCapacity(int desiredCapacity) {
        int requiredSize = desiredCapacity + this._size;
        if (requiredSize > this._maxSize) {
            this.rehash(PrimeFinder.nextPrime((int)Math.max(this._size + (this._size >> 1) + 1, HashFunctions.fastCeil((float)((float)requiredSize / DEFAULT_LOAD_FACTOR)) + 1)));
            this.computeMaxSize(this.capacity());
        }
    }

    protected void removeAt(int index) {
        --this._size;
    }

    public void clear() {
        this._size = 0;
    }

    protected int setUp(int initialCapacity) {
        if (initialCapacity == 0) {
            return 0;
        }
        int capacity = PrimeFinder.nextPrime((int)initialCapacity);
        this.computeMaxSize(capacity);
        return capacity;
    }

    protected abstract void rehash(int var1);

    protected void computeMaxSize(int capacity) {
        this._maxSize = Math.min(capacity - 1, (int)((float)capacity * DEFAULT_LOAD_FACTOR));
    }

    protected final void postInsertHook() {
        ++this._size;
    }

    protected int calculateGrownCapacity() {
        return this.capacity() << 1;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.setUp((int)Math.ceil(10.0f / DEFAULT_LOAD_FACTOR));
    }
}

