/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.spf4j.base.Threads;
import org.spf4j.stackmonitor.ISampler;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.StackCollector;
import org.spf4j.stackmonitor.StackCollectorImpl;

@NotThreadSafe
public final class ThreadStackSampler
implements ISampler {
    private final Supplier<Iterable<Thread>> threadSupplier;
    private final StackCollector collector;
    private Thread[] requestFor;

    public ThreadStackSampler(Supplier<Iterable<Thread>> threadSupplier) {
        this(20, threadSupplier);
    }

    public ThreadStackSampler(int maxSampledThreads, Supplier<Iterable<Thread>> threadSupplier) {
        this.requestFor = new Thread[maxSampledThreads];
        this.threadSupplier = threadSupplier;
        this.collector = new StackCollectorImpl();
    }

    @Override
    public void sample() {
        Iterable<Thread> currentThreads = this.threadSupplier.get();
        int i = 0;
        for (Thread t : currentThreads) {
            this.requestFor[i++] = t;
            if (i < this.requestFor.length) continue;
            break;
        }
        Arrays.fill(this.requestFor, i, this.requestFor.length, null);
        StackTraceElement[][] stackTraces = Threads.getStackTraces(this.requestFor);
        for (int j = 0; j < i; ++j) {
            StackTraceElement[] stackTrace = stackTraces[j];
            if (stackTrace != null && stackTrace.length > 0) {
                this.collector.collect(stackTrace);
                continue;
            }
            this.collector.collect(new StackTraceElement[]{new StackTraceElement("Thread", this.requestFor[j].getName(), "", 0)});
        }
    }

    @Override
    public Map<String, SampleNode> getCollectionsAndReset() {
        SampleNode nodes = this.collector.getAndReset();
        return nodes == null ? Collections.EMPTY_MAP : ImmutableMap.of((Object)this.threadSupplier.toString(), (Object)nodes);
    }

    @Override
    public Map<String, SampleNode> getCollections() {
        SampleNode nodes = this.collector.get();
        return nodes == null ? Collections.EMPTY_MAP : ImmutableMap.of((Object)this.threadSupplier.toString(), (Object)nodes);
    }

    public String toString() {
        return "ThreadStackSampler{threadSupplier=" + this.threadSupplier + ", collector=" + this.collector + '}';
    }
}

