/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.Threads;
import org.spf4j.stackmonitor.ISampler;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.StackCollector;
import org.spf4j.stackmonitor.StackCollectorImpl;

@NotThreadSafe
public class TracingExecutionContexSampler
implements ISampler {
    private final Supplier<Iterable<Map.Entry<Thread, ExecutionContext>>> execCtxSupplier;
    protected Thread[] requestFor;
    protected ExecutionContext[] contexts;
    private final TMap<String, StackCollector> collections;
    private final Function<ExecutionContext, String> ctxToCategory;

    public TracingExecutionContexSampler(Supplier<Iterable<Map.Entry<Thread, ExecutionContext>>> execCtxSupplier, Function<ExecutionContext, String> ctxToCategory) {
        this(100, execCtxSupplier, ctxToCategory);
    }

    public TracingExecutionContexSampler(int maxNrThreads, Supplier<Iterable<Map.Entry<Thread, ExecutionContext>>> execCtxSupplier, Function<ExecutionContext, String> ctxToCategory) {
        this.requestFor = new Thread[maxNrThreads];
        this.contexts = new ExecutionContext[maxNrThreads];
        this.execCtxSupplier = execCtxSupplier;
        this.collections = new THashMap();
        this.ctxToCategory = ctxToCategory;
    }

    @Override
    public final void sample() {
        Iterable<Map.Entry<Thread, ExecutionContext>> currentThreads = this.execCtxSupplier.get();
        int nrThreads = this.prepareThreadsAndContexts(currentThreads);
        if (nrThreads > 0) {
            Arrays.fill(this.requestFor, nrThreads, this.requestFor.length, null);
            StackTraceElement[][] stackTraces = Threads.getStackTraces(this.requestFor);
            for (int j = 0; j < nrThreads; ++j) {
                StackTraceElement[] stackTrace = stackTraces[j];
                if (stackTrace == null || stackTrace.length <= 0) continue;
                ExecutionContext context = this.contexts[j];
                context.add(stackTrace);
                String name = this.ctxToCategory.apply(context);
                StackCollector c = (StackCollector)this.collections.computeIfAbsent((Object)name, k -> new StackCollectorImpl());
                c.collect(stackTrace);
            }
        }
    }

    protected int prepareThreadsAndContexts(Iterable<Map.Entry<Thread, ExecutionContext>> currentThreads) {
        int i = 0;
        for (Map.Entry<Thread, ExecutionContext> entry : currentThreads) {
            this.requestFor[i] = entry.getKey();
            this.contexts[i++] = entry.getValue().getRootParent();
            if (i < this.requestFor.length) continue;
            break;
        }
        return i;
    }

    @Override
    public final Map<String, SampleNode> getCollectionsAndReset() {
        THashMap result = new THashMap(this.collections.size());
        this.collections.forEachEntry((arg_0, arg_1) -> TracingExecutionContexSampler.lambda$getCollectionsAndReset$1((TMap)result, arg_0, arg_1));
        return result;
    }

    @Override
    public final Map<String, SampleNode> getCollections() {
        THashMap result = new THashMap(this.collections.size());
        this.collections.forEachEntry((arg_0, arg_1) -> TracingExecutionContexSampler.lambda$getCollections$2((TMap)result, arg_0, arg_1));
        return result;
    }

    public String toString() {
        return "TracingExecutionContextStackCollector{execCtxSupplier=" + this.execCtxSupplier + ", collections=" + this.collections + '}';
    }

    private static /* synthetic */ boolean lambda$getCollections$2(TMap result, String k, StackCollector v) {
        result.put((Object)k, (Object)v.get());
        return true;
    }

    private static /* synthetic */ boolean lambda$getCollectionsAndReset$1(TMap result, String k, StackCollector v) {
        result.put((Object)k, (Object)v.getAndReset());
        return true;
    }
}

