/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.tsdb2;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.primitives.Longs;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.spf4j.base.DateTimeFormats;
import org.spf4j.base.Either;
import org.spf4j.base.Strings;
import org.spf4j.base.avro.AvroCloseableIterable;
import org.spf4j.io.Csv;
import org.spf4j.perf.TimeSeriesRecord;
import org.spf4j.tsdb2.TSDBReader;
import org.spf4j.tsdb2.TableDefs;
import org.spf4j.tsdb2.TimeSeries;
import org.spf4j.tsdb2.avro.ColumnDef;
import org.spf4j.tsdb2.avro.DataBlock;
import org.spf4j.tsdb2.avro.DataRow;
import org.spf4j.tsdb2.avro.MeasurementType;
import org.spf4j.tsdb2.avro.Observation;
import org.spf4j.tsdb2.avro.TableDef;

public final class TSDBQuery {
    private TSDBQuery() {
    }

    public static MeasurementType getMeasurementType(Schema schema) {
        String mt = schema.getProp("measurementType");
        if (mt == null) {
            return MeasurementType.UNTYPED;
        }
        return MeasurementType.valueOf((String)mt);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public static ListMultimap<String, TableDef> getAllTables(File tsdbFile) throws IOException {
        ArrayListMultimap result = ArrayListMultimap.create();
        try (TSDBReader reader = new TSDBReader(tsdbFile, 8192);){
            Either<TableDef, DataBlock> read;
            while ((read = reader.read()) != null) {
                if (!read.isLeft()) continue;
                TableDef tdef = read.getLeft();
                result.put((Object)tdef.getName(), (Object)tdef);
            }
        }
        return result;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public static ListMultimap<String, TableDef> getTables(File tsdbFile, Set<String> tables) throws IOException {
        ArrayListMultimap result = ArrayListMultimap.create();
        try (TSDBReader reader = new TSDBReader(tsdbFile, 8192);){
            Either<TableDef, DataBlock> read;
            while ((read = reader.read()) != null) {
                TableDef tdef;
                String name;
                if (!read.isLeft() || !tables.contains(name = (tdef = read.getLeft()).getName())) continue;
                result.put((Object)name, (Object)tdef);
            }
        }
        return result;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public static ListMultimap<String, TableDefEx> getAllTablesWithDataRanges(File tsdbFile) throws IOException {
        ArrayListMultimap result = ArrayListMultimap.create();
        TLongObjectHashMap id2Def = new TLongObjectHashMap();
        try (TSDBReader reader = new TSDBReader(tsdbFile, 8192);){
            Either<TableDef, DataBlock> read;
            while ((read = reader.read()) != null) {
                if (read.isLeft()) {
                    TableDef left = read.getLeft();
                    TableDefEx tableDefEx = new TableDefEx(left, Long.MAX_VALUE, 0L);
                    id2Def.put(left.getId(), (Object)tableDefEx);
                    result.put((Object)tableDefEx.getTableDef().getName(), (Object)tableDefEx);
                    continue;
                }
                DataBlock right = read.getRight();
                long baseTs = right.getBaseTimestamp();
                for (DataRow row : right.getValues()) {
                    TableDefEx tdex = (TableDefEx)id2Def.get(row.getTableDefId());
                    if (tdex == null) {
                        throw new IOException("Potentially corupted file data row with no tableDef " + row);
                    }
                    long ts = baseTs + (long)row.getRelTimeStamp();
                    if (ts < tdex.getStartTime()) {
                        tdex.setStartTime(ts);
                    }
                    if (ts <= tdex.getEndTime()) continue;
                    tdex.setEndTime(ts);
                }
            }
        }
        return result;
    }

    @Nonnull
    public static List<TableDef> getTableDef(File tsdbFile, String tableName) throws IOException {
        ArrayList<TableDef> result = new ArrayList<TableDef>();
        try (TSDBReader reader = new TSDBReader(tsdbFile, 8192);){
            Either<TableDef, DataBlock> read;
            while ((read = reader.read()) != null) {
                TableDef left;
                if (!read.isLeft() || !tableName.equals((left = read.getLeft()).getName())) continue;
                result.add(left);
            }
        }
        return result;
    }

    public static TimeSeries getTimeSeries(File tsdbFile, long[] tableIds, long startTimeMillis, long endTimeMillis) throws IOException {
        TLongArrayList timestamps = new TLongArrayList();
        ArrayList metrics = new ArrayList();
        TSDBQuery.getTimeSeries(tsdbFile, tableIds, startTimeMillis, endTimeMillis, (arg_0, arg_1) -> TSDBQuery.lambda$getTimeSeries$0((TLongList)timestamps, metrics, arg_0, arg_1));
        return new TimeSeries(timestamps.toArray(), (long[][])metrics.toArray((T[])new long[metrics.size()][]));
    }

    public static void getTimeSeries(File tsdbFile, long[] tableIds, long startTimeMillis, long endTimeMillis, BiConsumer<Long, long[]> consumer) throws IOException {
        try (TSDBReader reader = new TSDBReader(tsdbFile, 8192);){
            Either<TableDef, DataBlock> read;
            while ((read = reader.read()) != null) {
                if (!read.isRight()) continue;
                DataBlock data = read.getRight();
                long baseTs = data.getBaseTimestamp();
                for (DataRow row : data.getValues()) {
                    for (long tableId : tableIds) {
                        long ts;
                        if (tableId != row.getTableDefId() || (ts = baseTs + (long)row.getRelTimeStamp()) < startTimeMillis || ts > endTimeMillis) continue;
                        consumer.accept(ts, Longs.toArray((Collection)row.getData()));
                    }
                }
            }
        }
    }

    @Nullable
    public static AvroCloseableIterable<TimeSeriesRecord> getTimeSeriesData(File tsdbFile, String tableName, long startTimeMillis, long endTimeMillis) throws IOException {
        List<TableDef> tableDef = TSDBQuery.getTableDef(tsdbFile, tableName);
        if (tableDef.isEmpty()) {
            return null;
        }
        HashSet<Long> ids = new HashSet<Long>(Longs.asList((long[])TSDBQuery.getIds(tableDef)));
        TableDef td = tableDef.get(0);
        Schema rSchema = TableDefs.createSchema(td);
        return TSDBQuery.getTimeSeriesData(tsdbFile, startTimeMillis, endTimeMillis, ids, rSchema);
    }

    public static AvroCloseableIterable<TimeSeriesRecord> getTimeSeriesData(File tsdbFile, long startTimeMillis, long endTimeMillis, Collection<Long> ids, Schema rSchema) throws IOException {
        TSDBReader reader = new TSDBReader(tsdbFile, 8192);
        try {
            DataScan dataScan = new DataScan(reader);
            Iterable filtered = Iterables.filter((Iterable)dataScan, x -> {
                long ts = x.getRelTimeStamp();
                return ts >= startTimeMillis && ts <= endTimeMillis && ids.contains(x.getTableDefId());
            });
            Iterable it = Iterables.transform((Iterable)filtered, TSDBQuery.toRecord(rSchema));
            return AvroCloseableIterable.from(it, reader, rSchema);
        }
        catch (IOException | RuntimeException ex) {
            reader.close();
            throw ex;
        }
    }

    public static AvroCloseableIterable<Observation> getTimeSeriesData(File tsdbFile) throws IOException {
        TSDBReader reader = new TSDBReader(tsdbFile, 8192);
        try {
            DataScan dataScan = new DataScan(reader);
            return AvroCloseableIterable.from(dataScan, reader, Observation.getClassSchema());
        }
        catch (IOException | RuntimeException ex) {
            reader.close();
            throw ex;
        }
    }

    public static Function<Observation, TimeSeriesRecord> toRecord(Schema rSchema) {
        return x -> {
            GenericData.Record rec = new GenericData.Record(rSchema);
            rec.put(0, (Object)Instant.ofEpochMilli(x.getRelTimeStamp()));
            List nrs = x.getData();
            List fields = rSchema.getFields();
            int l = fields.size();
            block4: for (int i = 1; i < l; ++i) {
                Schema.Type type = ((Schema.Field)fields.get(i)).schema().getType();
                switch (type) {
                    case DOUBLE: {
                        rec.put(i, (Object)Double.longBitsToDouble((Long)nrs.get(i - 1)));
                        continue block4;
                    }
                    case LONG: {
                        rec.put(i, nrs.get(i - 1));
                        continue block4;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported data type: " + type);
                    }
                }
            }
            return TimeSeriesRecord.from((GenericRecord)rec);
        };
    }

    public static long[] getIds(Collection<TableDef> tableDefs) {
        long[] result = new long[tableDefs.size()];
        int i = 0;
        for (TableDef tdef : tableDefs) {
            result[i++] = tdef.getId();
        }
        return result;
    }

    public static void writeCsvTable(File tsDB, String tableName, File output) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(output.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            TSDBQuery.writeAsCsv(writer, tsDB, tableName);
        }
    }

    public static void writeAsCsv(Appendable writer, File tsDB, String tableName) throws IOException {
        List<TableDef> tableDefs = TSDBQuery.getTableDef(tsDB, tableName);
        TimeSeries data = TSDBQuery.getTimeSeries(tsDB, TSDBQuery.getIds(tableDefs), 0L, Long.MAX_VALUE);
        Csv.writeCsvElement("timestamp", writer);
        for (ColumnDef col : tableDefs.get(0).getColumns()) {
            writer.append(',');
            Csv.writeCsvElement(col.getName(), writer);
        }
        writer.append('\n');
        long[] timestamps = data.getTimeStamps();
        long[][] values = data.getValues();
        for (int i = 0; i < timestamps.length; ++i) {
            Csv.writeCsvElement(DateTimeFormats.TS_FORMAT.format(Instant.ofEpochMilli(timestamps[i])), writer);
            for (long val : values[i]) {
                writer.append(',');
                Csv.writeCsvElement(Long.toString(val), writer);
            }
            writer.append('\n');
        }
    }

    public static void writeCsvTables(File tsDB, Set<String> tableNames, File output) throws IOException {
        if (tableNames.isEmpty()) {
            return;
        }
        ListMultimap<String, TableDef> tables = TSDBQuery.getTables(tsDB, tableNames);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(output.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            TableDef table = (TableDef)tables.values().iterator().next();
            Csv.writeCsvElement("table", writer);
            writer.append(',');
            Csv.writeCsvElement("timestamp", writer);
            for (ColumnDef columnDef : table.getColumns()) {
                writer.append(',');
                Csv.writeCsvElement(columnDef.getName(), writer);
            }
            ((Writer)writer).write(10);
            for (Map.Entry entry : tables.asMap().entrySet()) {
                TimeSeries data = TSDBQuery.getTimeSeries(tsDB, TSDBQuery.getIds((Collection)entry.getValue()), 0L, Long.MAX_VALUE);
                long[] timestamps = data.getTimeStamps();
                long[][] values = data.getValues();
                for (int i = 0; i < timestamps.length; ++i) {
                    Csv.writeCsvElement((CharSequence)entry.getKey(), writer);
                    writer.append(',');
                    Csv.writeCsvElement(DateTimeFormats.TS_FORMAT.format(Instant.ofEpochMilli(timestamps[i])), writer);
                    for (long val : values[i]) {
                        writer.append(',');
                        Csv.writeCsvElement(Long.toString(val), writer);
                    }
                    ((Writer)writer).write(10);
                }
            }
        }
    }

    @Nullable
    public static ColumnDef getColumnDefIfExists(TableDef td, String columnName) {
        for (ColumnDef cdef : td.getColumns()) {
            if (!Strings.equals(columnName, cdef.getName())) continue;
            return cdef;
        }
        return null;
    }

    @Nonnull
    public static ColumnDef getColumnDef(TableDef td, String columnName) {
        for (ColumnDef cdef : td.getColumns()) {
            if (!columnName.equals(cdef.getName())) continue;
            return cdef;
        }
        throw new IllegalArgumentException("Column " + columnName + " not found in " + td);
    }

    public static int getColumnIndex(TableDef td, String columnName) {
        int i = 0;
        for (ColumnDef cdef : td.getColumns()) {
            if (columnName.equals(cdef.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String[] getColumnNames(TableDef td) {
        List columns = td.getColumns();
        String[] result = new String[columns.size()];
        int i = 0;
        for (ColumnDef cd : columns) {
            result[i++] = cd.getName();
        }
        return result;
    }

    public static String[] getColumnUnitsOfMeasurement(TableDef td) {
        List columns = td.getColumns();
        String[] result = new String[columns.size()];
        int i = 0;
        for (ColumnDef cd : columns) {
            result[i++] = cd.getUnitOfMeasurement();
        }
        return result;
    }

    private static /* synthetic */ void lambda$getTimeSeries$0(TLongList timestamps, List metrics, Long ts, long[] data) {
        timestamps.add(ts.longValue());
        metrics.add(data);
    }

    private static class DataScan
    implements Iterable<Observation> {
        private final TSDBReader reader;

        DataScan(TSDBReader tsdb) throws IOException {
            this.reader = tsdb;
        }

        @Override
        public Iterator<Observation> iterator() {
            return new Iterator<Observation>(){
                private long baseTs;
                private Iterator<DataRow> dataBlock;
                {
                    this.nextBlock();
                }

                private void nextBlock() {
                    try {
                        Either<TableDef, DataBlock> read;
                        while ((read = reader.read()) != null) {
                            if (!read.isRight()) continue;
                            DataBlock block = read.getRight();
                            this.baseTs = block.getBaseTimestamp();
                            this.dataBlock = block.getValues().iterator();
                            return;
                        }
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                    this.dataBlock = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.dataBlock != null) {
                        if (this.dataBlock.hasNext()) {
                            return true;
                        }
                        this.nextBlock();
                    }
                    return false;
                }

                @Override
                public Observation next() {
                    while (true) {
                        if (this.dataBlock == null) {
                            throw new NoSuchElementException();
                        }
                        if (this.dataBlock.hasNext()) {
                            DataRow next = this.dataBlock.next();
                            return new Observation(this.baseTs + (long)next.getRelTimeStamp(), next.getTableDefId(), next.getData());
                        }
                        this.nextBlock();
                    }
                }
            };
        }
    }

    public static final class TableDefEx {
        private final TableDef tableDef;
        private long startTime;
        private long endTime;

        public TableDefEx(TableDef tableDef, long startTime, long endTime) {
            this.tableDef = tableDef;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public TableDef getTableDef() {
            return this.tableDef;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public String toString() {
            return "TableDefEx{tableDef=" + this.tableDef + ", startTime=" + this.startTime + ", endTime=" + this.endTime + '}';
        }
    }
}

