/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.tsdb2;

import com.google.common.io.ByteStreams;
import com.google.common.primitives.Longs;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.spf4j.base.Strings;
import org.spf4j.io.BufferedInputStream;
import org.spf4j.io.ByteArrayBuilder;
import org.spf4j.recyclable.impl.ArraySuppliers;
import org.spf4j.tsdb2.avro.DataBlock;
import org.spf4j.tsdb2.avro.DataRow;
import org.spf4j.tsdb2.avro.Header;
import org.spf4j.tsdb2.avro.TableDef;

public final class TSDBWriter
implements Closeable,
Flushable {
    public static final Schema FILE_RECORD_SCHEMA = Schema.createUnion(Arrays.asList(TableDef.SCHEMA$, DataBlock.SCHEMA$));
    static final byte[] MAGIC = Strings.toUtf8("TSDB2");
    private final File file;
    private final FileChannel channel;
    private final BinaryEncoder encoder;
    private final Header header;
    private final SpecificDatumWriter<Object> recordWriter = new SpecificDatumWriter(FILE_RECORD_SCHEMA);
    private final DataBlock writeBlock;
    private final int maxRowsPerBlock;
    private final RandomAccessFile raf;
    private final ByteArrayBuilder bab;

    @CreatesObligation
    public TSDBWriter(File file, int maxRowsPerBlock, String description, boolean append) throws IOException {
        this.file = file;
        this.maxRowsPerBlock = maxRowsPerBlock;
        this.writeBlock = new DataBlock(System.currentTimeMillis(), new ArrayList(maxRowsPerBlock));
        this.raf = new RandomAccessFile(file, "rw");
        this.bab = new ByteArrayBuilder(32768, ArraySuppliers.Bytes.JAVA_NEW);
        this.encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)this.bab, null);
        this.channel = this.raf.getChannel();
        this.channel.lock();
        if (!append) {
            this.raf.setLength(0L);
            this.channel.force(true);
        }
        if (this.raf.length() <= 0L) {
            this.bab.write(MAGIC);
            TSDBWriter.toOutputStream(0L, this.bab);
            this.header = Header.newBuilder().setContentSchema(FILE_RECORD_SCHEMA.toString()).setDescription(description).build();
            SpecificDatumWriter headerWriter = new SpecificDatumWriter(Header.SCHEMA$);
            headerWriter.write((Object)this.header, (Encoder)this.encoder);
            this.encoder.flush();
            byte[] buffer = this.bab.getBuffer();
            int size = this.bab.size();
            TSDBWriter.toByteArray(size, buffer, MAGIC.length);
            this.raf.write(buffer, 0, size);
            this.channel.force(true);
        } else {
            if (description != null) {
                throw new IllegalArgumentException("Providing description when appending is not allowed for " + file);
            }
            try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
                 DataInputStream dis = new DataInputStream(bis);){
                TSDBWriter.validateType(dis);
                long size = dis.readLong();
                SpecificDatumReader reader = new SpecificDatumReader(Header.getClassSchema());
                BinaryDecoder directBinaryDecoder = DecoderFactory.get().directBinaryDecoder((InputStream)dis, null);
                this.header = (Header)reader.read(null, (Decoder)directBinaryDecoder);
                this.raf.seek(size);
            }
        }
    }

    static void validateType(InputStream dis) throws IOException {
        byte[] readMagic = new byte[MAGIC.length];
        ByteStreams.readFully((InputStream)dis, (byte[])readMagic);
        if (!Arrays.equals(MAGIC, readMagic)) {
            throw new IOException("wrong file type, magic is " + Arrays.toString(readMagic));
        }
    }

    public synchronized long writeTableDef(TableDef tableDef) throws IOException {
        long position = this.raf.getFilePointer();
        this.bab.reset();
        tableDef.setId(position);
        this.recordWriter.write((Object)tableDef, (Encoder)this.encoder);
        this.encoder.flush();
        this.raf.write(this.bab.getBuffer(), 0, this.bab.size());
        return position;
    }

    public synchronized void writeDataRow(long tableId, long timestamp, long ... data) throws IOException {
        List blockValues = this.writeBlock.getValues();
        if (blockValues.size() >= this.maxRowsPerBlock) {
            this.flush();
        }
        long baseTs = this.writeBlock.getBaseTimestamp();
        DataRow row = new DataRow((int)(timestamp - baseTs), tableId, Longs.asList((long[])data));
        blockValues.add(row);
    }

    @Override
    public synchronized void close() throws IOException {
        try (RandomAccessFile f = this.raf;){
            this.flush();
        }
    }

    public File getFile() {
        return this.file;
    }

    public static void toByteArray(long pvalue, byte[] bytes, int idx) {
        long value = pvalue;
        for (int i = idx + 7; i >= idx; --i) {
            bytes[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
    }

    public static void toOutputStream(long pvalue, OutputStream os) throws IOException {
        long value = pvalue;
        for (int i = 7; i >= 0; --i) {
            os.write((byte)(value & 0xFFL));
            value >>= 8;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        List blockValues = this.writeBlock.getValues();
        if (!blockValues.isEmpty()) {
            this.bab.reset();
            this.recordWriter.write((Object)this.writeBlock, (Encoder)this.encoder);
            this.encoder.flush();
            this.raf.write(this.bab.getBuffer(), 0, this.bab.size());
            this.channel.force(true);
            this.updateEOFPtrPointer();
            blockValues.clear();
        }
        this.channel.force(true);
    }

    private void updateEOFPtrPointer() throws IOException {
        long filePointer = this.raf.getFilePointer();
        this.raf.seek(MAGIC.length);
        this.raf.writeLong(filePointer);
        this.raf.seek(filePointer);
    }

    public Header getHeader() {
        return this.header;
    }

    public String toString() {
        return "TSDBWriter{file=" + this.file + ", raf=" + this.raf + '}';
    }
}

