/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.tsdb2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.spf4j.avro.AvroCompatUtils;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.TimeSeriesRecord;
import org.spf4j.tsdb2.avro.Aggregation;
import org.spf4j.tsdb2.avro.ColumnDef;
import org.spf4j.tsdb2.avro.DataRow;
import org.spf4j.tsdb2.avro.MeasurementType;
import org.spf4j.tsdb2.avro.Observation;
import org.spf4j.tsdb2.avro.TableDef;
import org.spf4j.tsdb2.avro.Type;

public final class TableDefs {
    private static final Schema INSTANT_SCHEMA = new Schema.Parser().parse("{\"type\":\"string\",\"logicalType\":\"instant\"}");

    private TableDefs() {
    }

    public static TableDef from(MeasurementsInfo measurement, int sampleTimeMillis, long id) {
        int numberOfMeasurements = measurement.getNumberOfMeasurements();
        ArrayList<ColumnDef> columns = new ArrayList<ColumnDef>(numberOfMeasurements);
        for (int i = 0; i < numberOfMeasurements; ++i) {
            String mname = measurement.getMeasurementName(i);
            String unit = measurement.getMeasurementUnit(i);
            Aggregation aggregation = measurement.getMeasurementAggregation(i);
            ColumnDef cd = new ColumnDef(mname, Type.LONG, unit, "", aggregation);
            columns.add(cd);
        }
        return new TableDef(id, measurement.getMeasuredEntity().toString(), "", columns, sampleTimeMillis, measurement.getMeasurementType());
    }

    public static Schema createSchema(TableDef td) {
        String rawName = td.getName();
        Schema recSchema = AvroCompatUtils.createRecordSchema(rawName.replace('.', '_'), td.getDescription(), null, false, false);
        List columns = td.getColumns();
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>(columns.size() + 1);
        fields.add(AvroCompatUtils.createField("ts", INSTANT_SCHEMA, "Measurement time stamp", null, true, false, Schema.Field.Order.IGNORE));
        block4: for (ColumnDef cd : columns) {
            Type type = cd.getType();
            switch (type) {
                case DOUBLE: {
                    Schema schema = Schema.create((Schema.Type)Schema.Type.DOUBLE);
                    schema.addProp("unit", cd.getUnitOfMeasurement());
                    schema.addProp("aggregation", cd.getAggregation().toString());
                    fields.add(AvroCompatUtils.createField(cd.getName(), schema, cd.getDescription(), null, true, false, Schema.Field.Order.IGNORE));
                    continue block4;
                }
                case LONG: {
                    Schema schema = Schema.create((Schema.Type)Schema.Type.LONG);
                    schema.addProp("unit", cd.getUnitOfMeasurement());
                    schema.addProp("aggregation", cd.getAggregation().toString());
                    fields.add(AvroCompatUtils.createField(cd.getName(), schema, cd.getDescription(), null, true, false, Schema.Field.Order.IGNORE));
                    continue block4;
                }
            }
            throw new IllegalStateException("Invalid data type " + type);
        }
        recSchema.setFields(fields);
        int sampleTime = td.getSampleTime();
        if (sampleTime > 0) {
            recSchema.addProp("frequencyMillis", (Object)sampleTime);
        }
        recSchema.addProp("measurementType", (Object)TableDefs.getMeasurementType(td));
        recSchema.addProp("rawName", rawName);
        return recSchema;
    }

    public static TimeSeriesRecord toRecord(Schema rSchema, long baseTs, DataRow row) {
        GenericData.Record rec = new GenericData.Record(rSchema);
        long ts = baseTs + (long)row.getRelTimeStamp();
        rec.put(0, (Object)Instant.ofEpochMilli(ts));
        List nrs = row.getData();
        List fields = rSchema.getFields();
        int i = 1;
        int l = fields.size();
        int j = 0;
        while (i < l) {
            Schema.Type type = ((Schema.Field)fields.get(i)).schema().getType();
            switch (type) {
                case DOUBLE: {
                    rec.put(i, (Object)Double.longBitsToDouble((Long)nrs.get(j)));
                    break;
                }
                case LONG: {
                    rec.put(i, nrs.get(j));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported data type: " + type);
                }
            }
            ++i;
            ++j;
        }
        return TimeSeriesRecord.from((GenericRecord)rec);
    }

    public static TimeSeriesRecord toRecord(Schema rSchema, Observation row) {
        GenericData.Record rec = new GenericData.Record(rSchema);
        rec.put(0, (Object)Instant.ofEpochMilli(row.getRelTimeStamp()));
        List nrs = row.getData();
        List fields = rSchema.getFields();
        int i = 1;
        int l = fields.size();
        int j = 0;
        while (i < l) {
            Schema.Type type = ((Schema.Field)fields.get(i)).schema().getType();
            switch (type) {
                case DOUBLE: {
                    rec.put(i, (Object)Double.longBitsToDouble((Long)nrs.get(j)));
                    break;
                }
                case LONG: {
                    rec.put(i, nrs.get(j));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported data type: " + type);
                }
            }
            ++i;
            ++j;
        }
        return TimeSeriesRecord.from((GenericRecord)rec);
    }

    @SuppressFBWarnings(value={"STT_STRING_PARSING_A_FIELD"})
    public static MeasurementType getMeasurementType(TableDef info) {
        MeasurementType measurementType = info.getMeasurementType();
        if (measurementType != MeasurementType.UNTYPED) {
            return measurementType;
        }
        boolean hasCount = false;
        for (ColumnDef colDef : info.getColumns()) {
            String colName = colDef.getName();
            if (colName.startsWith("Q") && colName.contains("_")) {
                return MeasurementType.HISTOGRAM;
            }
            if ("sum".equals(colName)) {
                return MeasurementType.SUMMARY;
            }
            if (!"count".equals(colName)) continue;
            hasCount = true;
        }
        if (hasCount) {
            return MeasurementType.COUNTER;
        }
        return MeasurementType.UNTYPED;
    }
}

