/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.unix;

import com.google.common.io.Files;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.IntByReference;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spf4j.base.Runtime;
import org.spf4j.unix.CLibrary;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public final class JVMArguments {
    private final List<String> arguments;

    public JVMArguments(int size) {
        this.arguments = new ArrayList<String>(size);
    }

    public JVMArguments(Collection<? extends String> c) {
        this.arguments = new ArrayList<String>(c);
    }

    public String getExecutable() {
        return this.arguments.get(0);
    }

    @Nullable
    public String removeSystemProperty(String pname) {
        Iterator<String> itr = this.arguments.iterator();
        itr.next();
        int nl = pname.length();
        while (itr.hasNext()) {
            String s = itr.next();
            if (!s.startsWith("-D") || !s.regionMatches(2, pname, 0, nl)) continue;
            int l = nl + 2;
            if (s.length() == l) {
                itr.remove();
                return "";
            }
            if (s.charAt(l) != '=') continue;
            itr.remove();
            return s.substring(l + 1);
        }
        return null;
    }

    @Nullable
    public String getSystemProperty(String pname) {
        Iterator<String> itr = this.arguments.iterator();
        itr.next();
        int nl = pname.length();
        while (itr.hasNext()) {
            String s = itr.next();
            if (!s.startsWith("-D") || !s.regionMatches(2, pname, 0, nl)) continue;
            int l = nl + 2;
            if (s.length() == l) {
                return "";
            }
            if (s.charAt(l) != '=') continue;
            return s.substring(l + 1);
        }
        return null;
    }

    @Nullable
    public void createOrUpdateSystemProperty(String pname, Function<String, String> replacer) {
        ListIterator<String> itr = this.arguments.listIterator();
        itr.next();
        int nl = pname.length();
        while (itr.hasNext()) {
            String s = itr.next();
            if (!s.startsWith("-D") || !s.regionMatches(2, pname, 0, nl)) continue;
            int l = nl + 2;
            if (s.length() == l) {
                itr.set("-D" + pname + '=' + replacer.apply(""));
                return;
            }
            if (s.charAt(l) != '=') continue;
            itr.set("-D" + pname + '=' + replacer.apply(s.substring(l + 1)));
            return;
        }
        this.arguments.add(1, "-D" + pname + '=' + replacer.apply(null));
    }

    public boolean hasSystemProperty(String pname) {
        Iterator<String> itr = this.arguments.iterator();
        itr.next();
        int nl = pname.length();
        while (itr.hasNext()) {
            String s = itr.next();
            if (!s.startsWith("-D") || !s.regionMatches(2, pname, 0, nl)) continue;
            int l = nl + 2;
            if (s.length() == l) {
                return true;
            }
            if (s.charAt(l) != '=') continue;
            return true;
        }
        return false;
    }

    public int removeAllSystemPropertiesStartingWith(String pname) {
        String name = "-D" + pname;
        int nrRemoved = 0;
        Iterator<String> itr = this.arguments.iterator();
        itr.next();
        while (itr.hasNext()) {
            String s = itr.next();
            if (!s.startsWith(name)) continue;
            itr.remove();
            ++nrRemoved;
        }
        return nrRemoved;
    }

    public void setSystemProperty(String name, String value) {
        this.removeSystemProperty(name);
        this.arguments.add(1, "-D" + name + '=' + value);
    }

    public void setVMArgument(String argument) {
        if (!this.hasVMArgument(argument)) {
            this.arguments.add(1, argument);
        }
    }

    public boolean removeVMArgument(String argument) {
        Iterator<String> itr = this.arguments.iterator();
        itr.next();
        while (itr.hasNext()) {
            String s = itr.next();
            if (!s.equals(argument)) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public boolean removeVMArgumentStartingWith(String argument) {
        Iterator<String> itr = this.arguments.iterator();
        itr.next();
        while (itr.hasNext()) {
            String s = itr.next();
            if (!s.startsWith(argument)) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public boolean hasVMArgument(String argument) {
        Iterator<String> itr = this.arguments.iterator();
        itr.next();
        while (itr.hasNext()) {
            String s = itr.next();
            if (!s.equals(argument)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVMArgumentStartingWith(String argumentPrefix) {
        Iterator<String> itr = this.arguments.iterator();
        itr.next();
        while (itr.hasNext()) {
            String s = itr.next();
            if (!s.startsWith(argumentPrefix)) continue;
            return true;
        }
        return false;
    }

    public void add(String arg) {
        this.arguments.add(arg);
    }

    public void removeTail(int n) {
        int size = this.arguments.size();
        this.arguments.removeAll(this.arguments.subList(size - n, size));
    }

    public StringArray toStringArray() {
        return new StringArray(this.arguments.toArray(new String[this.arguments.size()]));
    }

    public static JVMArguments current() throws IOException {
        return JVMArguments.of(-1);
    }

    public static JVMArguments of(int pid) throws IOException {
        String os;
        switch (os = Runtime.OS_NAME) {
            case "Linux": {
                return JVMArguments.ofLinux(pid);
            }
            case "SunOS": {
                return JVMArguments.ofSolaris(pid);
            }
            case "Mac OS X": {
                return JVMArguments.ofMac(pid);
            }
            case "FreeBSD": {
                return JVMArguments.ofFreeBSD(pid);
            }
        }
        throw new UnsupportedOperationException("Unsupported Operating System " + os);
    }

    private static JVMArguments ofLinux(int ppid) throws IOException {
        int pid = JVMArguments.resolvePID(ppid);
        String cmdline = Files.asCharSource((File)new File("/proc/" + pid + "/cmdline"), (Charset)Charset.defaultCharset()).read();
        return new JVMArguments(Arrays.asList(cmdline.split("\u0000")));
    }

    private static int resolvePID(int pid) {
        if (pid == -1) {
            return Runtime.PID;
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JVMArguments ofSolaris(int ppid) throws IOException {
        boolean areWe64 = "64".equals(System.getProperty("sun.arch.data.model"));
        int pid = JVMArguments.resolvePID(ppid);
        RandomAccessFile psinfo = new RandomAccessFile(new File("/proc/" + pid + "/psinfo"), "r");
        Throwable throwable = null;
        psinfo.seek(8L);
        if (JVMArguments.adjust(psinfo.readInt()) != pid) {
            throw new IOException("psinfo PID mismatch: " + pid + ", " + psinfo);
        }
        psinfo.seek(areWe64 ? 236L : 188L);
        int argc = JVMArguments.adjust(psinfo.readInt());
        long argp = areWe64 ? JVMArguments.adjust(psinfo.readLong()) : JVMArguments.to64(JVMArguments.adjust(psinfo.readInt()));
        File asFile = new File("/proc/" + pid + "/as");
        if (areWe64) {
            CLibrary.FILE fp = CLibrary.INSTANCE.fopen(asFile.getPath(), "r");
            try {
                JVMArguments args = new JVMArguments(16);
                Memory m = new Memory(8L);
                for (int n = 0; n < argc; ++n) {
                    JVMArguments.seek64(fp, argp + (long)n * 8L);
                    m.setLong(0L, 0L);
                    CLibrary.INSTANCE.fread((Pointer)m, 1, 8, fp);
                    long p = m.getLong(0L);
                    args.add(JVMArguments.readLine(fp, p));
                }
                JVMArguments n = args;
                return n;
            }
            finally {
                CLibrary.INSTANCE.fclose(fp);
            }
        }
        RandomAccessFile as = new RandomAccessFile(asFile, "r");
        Throwable throwable2 = null;
        try {
            JVMArguments args = new JVMArguments(16);
            for (int n = 0; n < argc; ++n) {
                as.seek(argp + (long)(n * 4));
                int p = JVMArguments.adjust(as.readInt());
                args.add(JVMArguments.readLine(as, p));
            }
            JVMArguments jVMArguments = args;
            return jVMArguments;
        }
        catch (Throwable throwable4) {
            try {
                throwable2 = throwable4;
                throw throwable4;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (as != null) {
                    if (throwable2 != null) {
                        try {
                            as.close();
                        }
                        catch (Throwable throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                    } else {
                        as.close();
                    }
                }
            }
        }
        finally {
            if (psinfo != null) {
                if (throwable != null) {
                    try {
                        psinfo.close();
                    }
                    catch (Throwable p) {
                        throwable.addSuppressed(p);
                    }
                } else {
                    psinfo.close();
                }
            }
        }
    }

    private static void seek64(CLibrary.FILE fp, long pupos) {
        long upos;
        long chunk;
        CLibrary.INSTANCE.fseek(fp, 0L, 0);
        for (upos = pupos; upos < 0L; upos -= chunk) {
            chunk = Long.MAX_VALUE;
            CLibrary.INSTANCE.fseek(fp, chunk, 1);
        }
        CLibrary.INSTANCE.fseek(fp, upos, 1);
    }

    private static int adjust(int i) {
        if (Runtime.IS_LITTLE_ENDIAN) {
            return i << 24 | i << 8 & 0xFF0000 | i >> 8 & 0xFF00 | i >>> 24;
        }
        return i;
    }

    private static long adjust(long i) {
        if (Runtime.IS_LITTLE_ENDIAN) {
            return i << 56 | i << 40 & 0xFF000000000000L | i << 24 & 0xFF0000000000L | i << 8 & 0xFF00000000L | i >> 8 & 0xFF000000L | i >> 24 & 0xFF0000L | i >> 40 & 0xFF00L | i >> 56;
        }
        return i;
    }

    private static long to64(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    private static String readLine(RandomAccessFile as, int p) throws IOException {
        int ch;
        as.seek(JVMArguments.to64(p));
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while ((ch = as.read()) > 0) {
            buf.write(ch);
        }
        return buf.toString();
    }

    private static String readLine(CLibrary.FILE as, long p) {
        byte b;
        JVMArguments.seek64(as, p);
        Memory m = new Memory(1L);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while (CLibrary.INSTANCE.fread((Pointer)m, 1, 1, as) != 0 && (b = m.getByte(0L)) != 0) {
            buf.write(b);
        }
        return buf.toString();
    }

    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    private static JVMArguments ofMac(int pid) {
        boolean ctlKern = true;
        int kernArgMax = 8;
        int kernProcArgs2 = 49;
        int sizeOfInt = Native.getNativeSize(Integer.TYPE);
        IntByReference ibf = new IntByReference();
        IntByReference argmaxRef = new IntByReference(0);
        IntByReference size = new IntByReference(sizeOfInt);
        if (CLibrary.INSTANCE.sysctl(new int[]{1, 8}, 2, argmaxRef.getPointer(), size, Pointer.NULL, ibf) != 0) {
            throw new UnsupportedOperationException("Failed to get kernl.argmax: " + CLibrary.INSTANCE.strerror(Native.getLastError()));
        }
        int argmax = argmaxRef.getValue();
        StringArrayMemory m = new StringArrayMemory(argmax, sizeOfInt);
        size.setValue(argmax);
        if (CLibrary.INSTANCE.sysctl(new int[]{1, 49, JVMArguments.resolvePID(pid)}, 3, (Pointer)m, size, Pointer.NULL, ibf) != 0) {
            throw new UnsupportedOperationException("Failed to obtain ken.procargs2: " + CLibrary.INSTANCE.strerror(Native.getLastError()));
        }
        int nargs = m.readInt();
        JVMArguments args = new JVMArguments(nargs);
        m.readString();
        for (int i = 0; i < nargs; ++i) {
            m.skip0();
            args.add(m.readString());
        }
        return args;
    }

    private static JVMArguments ofFreeBSD(int pid) {
        boolean ctlKern = true;
        int kernArgMax = 8;
        int kernProc = 14;
        int kernProcArgs = 7;
        IntByReference ibr = new IntByReference();
        IntByReference sysctlArgMax = new IntByReference();
        IntByReference size = new IntByReference();
        size.setValue(4);
        if (CLibrary.INSTANCE.sysctl(new int[]{1, 8}, 2, sysctlArgMax.getPointer(), size, Pointer.NULL, ibr) != 0) {
            throw new UnsupportedOperationException("Failed to sysctl kern.argmax");
        }
        int argmax = sysctlArgMax.getValue();
        Memory m = new Memory((long)argmax);
        size.setValue(argmax);
        if (CLibrary.INSTANCE.sysctl(new int[]{1, 14, 7, JVMArguments.resolvePID(pid)}, 4, (Pointer)m, size, Pointer.NULL, ibr) != 0) {
            throw new UnsupportedOperationException();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrayList<String> lArgs = new ArrayList<String>();
        int offset = 0;
        while (offset < size.getValue()) {
            byte ch;
            while ((ch = m.getByte((long)offset++)) != 0) {
                baos.write(ch);
            }
            lArgs.add(baos.toString());
            baos.reset();
        }
        return new JVMArguments(lArgs);
    }

    public String toString() {
        return "JVMArguments{arguments=" + this.arguments + '}';
    }

    public int hashCode() {
        return 77 + Objects.hashCode(this.arguments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JVMArguments other = (JVMArguments)obj;
        return Objects.equals(this.arguments, other.arguments);
    }

    public String[] toArray() {
        return this.arguments.toArray(new String[this.arguments.size()]);
    }

    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
    private static final class StringArrayMemory
    extends Memory {
        private long offset = 0L;
        private final int sizeOfInt;

        StringArrayMemory(long l, int sizeOfInt) {
            super(l);
            this.sizeOfInt = sizeOfInt;
        }

        private int readInt() {
            int r = this.getInt(this.offset);
            this.offset += (long)this.sizeOfInt;
            return r;
        }

        private String readString() {
            byte ch;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((ch = this.getByte(this.offset++)) != 0) {
                baos.write(ch);
            }
            return baos.toString();
        }

        void skip0() {
            while (this.getByte(this.offset) == 0) {
                ++this.offset;
            }
        }
    }
}

