/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.unix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.spf4j.base.Runtime;
import org.spf4j.base.SysExits;
import org.spf4j.os.OperatingSystem;
import org.spf4j.os.ProcessResponse;
import org.spf4j.os.StdOutLineCountProcessHandler;

@SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME", "FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public final class Lsof {
    private static final File LSOF;
    private static final String[] LSOF_CMD;

    private Lsof() {
    }

    public static int getNrOpenFiles() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        if (LSOF == null) {
            return -1;
        }
        ProcessResponse<Long, String> resp = OperatingSystem.forkExec(LSOF_CMD, new StdOutLineCountProcessHandler(), 60000L, 60000L);
        if (resp.getResponseExitCode() != SysExits.OK) {
            throw new ExecutionException("Failed to execute " + Arrays.toString(LSOF_CMD) + ", returned" + resp.getResponseCode() + ", stderr = " + resp.getErrOutput(), null);
        }
        return (int)(resp.getOutput() - 1L);
    }

    @Nullable
    @CheckReturnValue
    public static CharSequence getLsofOutput() {
        if (LSOF == null) {
            return null;
        }
        try {
            return Runtime.run(LSOF_CMD, 60000L);
        }
        catch (IOException | ExecutionException | TimeoutException ex) {
            Logger.getLogger(Lsof.class.getName()).log(Level.WARNING, "Unable to run lsof", ex);
            return null;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    static {
        String[] stringArray;
        File lsofFile = new File("/usr/sbin/lsof");
        if (!(lsofFile.exists() && lsofFile.canExecute() || (lsofFile = new File("/usr/bin/lsof")).exists() && lsofFile.canExecute() || (lsofFile = new File("/usr/local/bin/lsof")).exists() && lsofFile.canExecute())) {
            lsofFile = null;
        }
        if (lsofFile == null) {
            Logger.getLogger(Lsof.class.getName()).warning("lsof unavailable on this system");
        }
        if ((LSOF = lsofFile) == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[3];
            stringArray2[0] = LSOF.getAbsolutePath();
            stringArray2[1] = "-p";
            stringArray = stringArray2;
            stringArray2[2] = Integer.toString(Runtime.PID);
        }
        LSOF_CMD = stringArray;
    }
}

