/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.unix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.spf4j.base.Arrays;
import org.spf4j.base.Runtime;

@Deprecated
@SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
public final class Ulimit {
    private static final String[] ULIMIT_CMD = Runtime.isWindows() ? null : Ulimit.findUlimitCmd();

    private Ulimit() {
    }

    @Nullable
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    private static String[] findUlimitCmd() {
        File bash = new File("/bin/bash");
        File sh = new File("/bin/sh");
        File uLimit = new File("/usr/bin/ulimit");
        if (uLimit.exists() && uLimit.canExecute()) {
            return new String[]{uLimit.getPath()};
        }
        if (bash.exists() && bash.canExecute()) {
            return new String[]{bash.getPath(), "-c", "ulimit"};
        }
        if (sh.exists() && sh.canExecute()) {
            return new String[]{sh.getPath(), "-c", "ulimit"};
        }
        return null;
    }

    public static int runUlimit(String ... options) {
        int mfiles;
        if (ULIMIT_CMD == null) {
            Logger.getLogger(Ulimit.class.getName()).warning("Ulimit not available, assuming no limits");
            return Integer.MAX_VALUE;
        }
        try {
            String[] cmd = Arrays.concat(ULIMIT_CMD, options);
            String result = Runtime.run(cmd, 10000L).toString();
            if (result.contains("unlimited")) {
                mfiles = Integer.MAX_VALUE;
            } else {
                try {
                    mfiles = Integer.parseInt(result.trim());
                }
                catch (NumberFormatException ex) {
                    Logger.getLogger(Ulimit.class.getName()).log(Level.WARNING, "Error while parsing ulimit output, assuming no limit", ex);
                    mfiles = Integer.MAX_VALUE;
                }
            }
        }
        catch (IOException | ExecutionException | TimeoutException ex) {
            Logger.getLogger(Ulimit.class.getName()).log(Level.WARNING, "Error while parsing ulimit output, assuming no limit", ex);
            mfiles = Integer.MAX_VALUE;
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Ulimit.class.getName()).log(Level.WARNING, "Ulimit interrupted, assuming no limit", ex);
            Thread.currentThread().interrupt();
            mfiles = Integer.MAX_VALUE;
        }
        return mfiles;
    }
}

