/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.unix;

import com.sun.jna.Native;
import com.sun.jna.platform.unix.Resource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.spf4j.os.OperatingSystem;
import org.spf4j.unix.CLibrary;
import org.spf4j.unix.UnixException;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public enum UnixResources {
    RLIMIT_CPU(0),
    RLIMIT_FSIZE(1),
    RLIMIT_DATA(2),
    RLIMIT_STACK(3),
    RLIMIT_CORE(4),
    RLIMIT_RSS(5),
    RLIMIT_NPROC(6, 7),
    RLIMIT_NOFILE(7, 8),
    RLIMIT_MEMLOCK(8, 6),
    RLIMIT_AS(9, 5),
    RLIMIT_LOCKS(10, -1),
    RLIMIT_SIGPENDING(11, -1),
    RLIMIT_MSGQUEUE(12, -1),
    RLIMIT_NICE(13, -1),
    RLIMIT_RTPRIO(14, -1),
    RLIMIT_RTTIME(15, -1),
    RLIMIT_NLIMITS(16, 9);

    private final int macId;
    private final int gnuId;

    private UnixResources(int gnuId) {
        this.macId = gnuId;
        this.gnuId = gnuId;
    }

    private UnixResources(int gnuId, int macId) {
        this.macId = macId;
        this.gnuId = gnuId;
    }

    public int getMacId() {
        return this.macId;
    }

    public int getGnuId() {
        return this.gnuId;
    }

    public long getSoftLimit() throws UnixException {
        return UnixResources.getRLimit((UnixResources)this).rlim_cur;
    }

    public void setSoftLimit(long limit) throws UnixException {
        UnixResources.setRLimit(this, limit, this.getHardLimit());
    }

    public void setLimits(long softLimit, long hardlimit) throws UnixException {
        UnixResources.setRLimit(this, softLimit, hardlimit);
    }

    public long getHardLimit() throws UnixException {
        return UnixResources.getRLimit((UnixResources)this).rlim_max;
    }

    private static Resource.Rlimit getRLimit(UnixResources resourceId) throws UnixException {
        int id;
        int n = id = OperatingSystem.isMacOsx() ? resourceId.macId : resourceId.gnuId;
        if (id < 0) {
            throw new UnixException("Unsupported " + id + " limit on " + OperatingSystem.getOsName(), 0);
        }
        Resource.Rlimit limit = new Resource.Rlimit();
        int err = CLibrary.INSTANCE.getrlimit(id, limit);
        if (err != 0) {
            int lastError = Native.getLastError();
            throw new UnixException("Error code " + CLibrary.INSTANCE.strerror(lastError) + " for getrlimit(" + id + ", " + limit + '\'', lastError);
        }
        return limit;
    }

    private static void setRLimit(UnixResources resourceId, long softValue, long hardValue) throws UnixException {
        int id;
        int n = id = OperatingSystem.isMacOsx() ? resourceId.macId : resourceId.gnuId;
        if (id < 0) {
            throw new UnixException("Unsupported " + id + " limit on " + OperatingSystem.getOsName(), 0);
        }
        Resource.Rlimit limit = new Resource.Rlimit();
        limit.rlim_cur = softValue;
        limit.rlim_max = hardValue;
        int err = CLibrary.INSTANCE.setrlimit(id, limit);
        if (err != 0) {
            int lastError = Native.getLastError();
            throw new UnixException("Error " + CLibrary.INSTANCE.strerror(lastError) + " for setrlimit(" + id + ", " + limit + '\'', lastError);
        }
    }
}

