/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.unix;

import com.sun.jna.Native;
import java.io.IOException;
import org.spf4j.base.JNA;
import org.spf4j.unix.CLibrary;
import org.spf4j.unix.JVMArguments;

public final class UnixRuntime {
    private UnixRuntime() {
    }

    public static void restart() throws IOException {
        UnixRuntime.restart(JVMArguments.current());
    }

    public static void restart(JVMArguments newArguments) throws IOException {
        if (JNA.haveJnaPlatformClib()) {
            newArguments.createOrUpdateSystemProperty("spf4j.restart", old -> old == null ? "1" : Integer.toString(Integer.parseInt(old) + 1));
            int sz = CLibrary.INSTANCE.getdtablesize();
            for (int i = 3; i < sz; ++i) {
                int flags = CLibrary.INSTANCE.fcntl(i, 1);
                if (flags < 0) continue;
                CLibrary.INSTANCE.fcntl(i, 2, flags | 1);
            }
            String exe = newArguments.getExecutable();
            CLibrary.INSTANCE.execvp(exe, newArguments.toStringArray());
            throw new IOException("Failed to exec '" + exe + "' " + CLibrary.INSTANCE.strerror(Native.getLastError()));
        }
        throw new UnsupportedOperationException();
    }
}

