/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.unix;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import javax.annotation.Nonnull;

public final class UnixRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final int errno;
    private final String msg;

    public UnixRuntimeException(String msg, int errNo) {
        this.errno = errNo;
        this.msg = msg;
    }

    public int errno() {
        return this.errno;
    }

    public String errorString() {
        if (this.msg != null) {
            return this.msg;
        }
        return "No message available, strerror invocation not implemented yet";
    }

    @Override
    public String getMessage() {
        return this.errorString();
    }

    @Nonnull
    public IOException translateToIOException(String file, String other) {
        if (this.msg != null) {
            return new IOException(this.msg);
        }
        if (this.errno() == 13) {
            return new AccessDeniedException(file, other, null);
        }
        if (this.errno() == 2) {
            return new NoSuchFileException(file, other, null);
        }
        if (this.errno() == 17) {
            return new FileAlreadyExistsException(file, other, null);
        }
        return new FileSystemException(file, other, this.errorString());
    }

    public void rethrowAsIOException(String file) throws IOException {
        IOException x = this.translateToIOException(file, null);
        throw x;
    }
}

