/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Runtime;
import org.spf4j.base.Throwables;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.log.Level;
import org.spf4j.os.OperatingSystem;
import org.spf4j.os.StdOutToStringProcessHandler;
import org.spf4j.test.log.LogCollection;
import org.spf4j.test.log.TestLoggers;
import org.spf4j.test.log.annotations.ExpectLog;

public final class RuntimeTest {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeTest.class);

    @Test
    public void testHaveJnaPlatform() {
        Assert.assertTrue((boolean)Runtime.haveJnaPlatform());
    }

    @Test
    public void testSpecVersion() {
        Assert.assertEquals((Object)Runtime.Version.V1_8, (Object)Runtime.Version.fromSpecVersion((String)"1.8.0_151"));
    }

    @Test
    public void testMainClass() throws NoSuchMethodException {
        Class mainClass = Runtime.getMainClass();
        Assert.assertNotNull((Object)mainClass);
        Method method = mainClass.getMethod("main", String[].class);
        Assert.assertNotNull((Object)method);
    }

    @Test
    public void testMaxOpenFiles() {
        Assume.assumeFalse((boolean)Runtime.isWindows());
        Assert.assertNotEquals((long)Integer.MAX_VALUE, (long)OperatingSystem.getMaxFileDescriptorCount());
    }

    @Test
    public void testSomeParams() {
        LOG.debug("PID={}", (Object)Runtime.PID);
        LOG.debug("OSNAME={}", (Object)Runtime.OS_NAME);
        int nrOpenFiles = Runtime.getNrOpenFiles();
        LOG.debug("NR_OPEN_FILES={}", (Object)nrOpenFiles);
        Assert.assertThat((Object)nrOpenFiles, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        CharSequence lsofOutput = Runtime.getLsofOutput();
        LOG.debug("LSOF_OUT={}", (Object)lsofOutput);
        Assert.assertNotNull((Object)lsofOutput);
        Assert.assertThat((Object)lsofOutput.toString(), (Matcher)Matchers.containsString((String)"jar"));
        LOG.debug("MAX_OPEN_FILES={}", (Object)OperatingSystem.getMaxFileDescriptorCount());
    }

    @Test(expected=ExecutionException.class, timeout=60000L)
    @ExpectLog(category="org.spf4j.os", level=Level.ERROR, nrTimes=2)
    public void testExitCode() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        Runtime.jrun(TestError.class, (long)60000L, (String[])new String[0]);
    }

    @ExpectLog(category="org.spf4j.os", level=Level.ERROR, nrTimes=2)
    @Test(expected=ExecutionException.class, timeout=60000L)
    public void testExitCode2() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        Runtime.jrun(TestError2.class, (long)60000L, (String[])new String[0]);
    }

    @Test(expected=TimeoutException.class, timeout=30000L)
    public void testExitCode3() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        LogCollection collect = TestLoggers.sys().collect(StdOutToStringProcessHandler.class.getName(), Level.ERROR, Level.ERROR, false, Collectors.counting());
        Runtime.jrun(TestError3.class, (long)10000L, (String[])new String[0]);
        Assert.assertTrue(((Long)collect.get() > 0L ? 1 : 0) != 0);
    }

    @Test(expected=InterruptedException.class, timeout=30000L)
    public void testExitCode4() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        Thread t = Thread.currentThread();
        DefaultScheduler.INSTANCE.schedule(() -> t.interrupt(), 1L, TimeUnit.SECONDS);
        Runtime.jrun(TestSleeping.class, (long)10000L, (String[])new String[0]);
    }

    @Test(expected=CancellationException.class, timeout=30000L)
    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
    public void testExitCode5() throws InterruptedException, ExecutionException, TimeoutException {
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch canCancel = new CountDownLatch(1);
        Future<?> submit = DefaultExecutor.INSTANCE.submit((Runnable)new AbstractRunnable(){

            public void doRun() throws IOException, InterruptedException, ExecutionException, TimeoutException {
                try {
                    canCancel.countDown();
                    Runtime.jrun(TestError3.class, (long)10000L, (String[])new String[0]);
                }
                catch (InterruptedException ex) {
                    Throwables.writeTo((Throwable)ex, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
                    latch.countDown();
                }
                catch (Exception ex) {
                    Throwables.writeTo((Throwable)ex, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
                }
            }
        });
        if (!canCancel.await(3000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"exec should happen");
        }
        submit.cancel(true);
        if (!latch.await(15000L, TimeUnit.SECONDS)) {
            Assert.fail((String)"exec should be cancelled");
        }
        submit.get(10000L, TimeUnit.MILLISECONDS);
    }

    public static final class TestError3 {
        public static void main(String[] args) {
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> Throwables.writeTo((Throwable)e, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT));
            DefaultScheduler.INSTANCE.scheduleAtFixedRate(AbstractRunnable.NOP, 10L, 10L, TimeUnit.MILLISECONDS);
            throw new RuntimeException();
        }
    }

    public static final class TestError2 {
        public static void main(String[] args) {
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> Throwables.writeTo((Throwable)e, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT));
            throw new RuntimeException();
        }
    }

    public static final class TestError {
        public static void main(String[] args) {
            throw new RuntimeException();
        }
    }

    public static final class TestSleeping {
        @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
        public static void main(String[] args) throws InterruptedException {
            Thread.sleep(60000L);
        }
    }
}

