/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Throwables;

public final class ThrowablesTest {
    private static final Logger LOG = LoggerFactory.getLogger(ThrowablesTest.class);

    @Test
    public void testSuppress() {
        Exception e = new RuntimeException(new RuntimeException(new RuntimeException()));
        for (int i = 0; i < 10; ++i) {
            e = (Exception)Throwables.suppress((Throwable)e, (Throwable)new RuntimeException());
        }
        Throwable[] suppressed = Throwables.getSuppressed((Throwable)e);
        Assert.assertEquals((long)10L, (long)suppressed.length);
        SQLException sqlException = new SQLException(e);
        sqlException.setNextException(new SQLException("bla", new RuntimeException(new RuntimeException())));
        sqlException.setNextException(new SQLException("bla"));
        LOG.debug("Thowable", (Throwable)sqlException);
        Assert.assertEquals((long)2L, (long)Throwables.getSuppressed((Throwable)sqlException).length);
    }

    @Test
    public void testSuppressedManipulation() {
        Exception ex = new Exception("test");
        Assert.assertEquals((long)0L, (long)Throwables.getNrSuppressedExceptions((Throwable)ex));
        Exception sex = new Exception("tests");
        ex.addSuppressed(sex);
        Assert.assertEquals((long)1L, (long)Throwables.getNrSuppressedExceptions((Throwable)ex));
        sex.addSuppressed(new Exception("tests2"));
        Assert.assertEquals((long)1L, (long)Throwables.getNrSuppressedExceptions((Throwable)ex));
        Assert.assertEquals((long)2L, (long)Throwables.getNrRecursiveSuppressedExceptions((Throwable)ex));
        Throwables.removeOldestSuppressedRecursive((Throwable)ex);
        Assert.assertEquals((long)1L, (long)Throwables.getNrRecursiveSuppressedExceptions((Throwable)ex));
        Exception exs = new Exception(ex);
        for (int i = 0; i < 500; ++i) {
            exs = (Exception)Throwables.suppress((Throwable)new Exception("test" + i), (Throwable)exs);
        }
        Assert.assertEquals((long)100L, (long)Throwables.getNrRecursiveSuppressedExceptions((Throwable)exs));
    }

    @Test
    public void testRecoverable() {
        RuntimeException t = new RuntimeException();
        Assert.assertFalse((boolean)Throwables.containsNonRecoverable((Throwable)t));
        t.addSuppressed(new IOException());
        Assert.assertFalse((boolean)Throwables.containsNonRecoverable((Throwable)t));
        t.addSuppressed(new OutOfMemoryError());
        Assert.assertTrue((boolean)Throwables.containsNonRecoverable((Throwable)t));
        t = new RuntimeException(new RuntimeException(new IOException("Too many open files")));
        Assert.assertTrue((boolean)Throwables.containsNonRecoverable((Throwable)t));
        t = new RuntimeException(new RuntimeException(new StackOverflowError()));
        Assert.assertFalse((boolean)Throwables.containsNonRecoverable((Throwable)t));
    }

    @Test
    public void testAbbreviation() throws IOException {
        StringBuilder sb = new StringBuilder();
        Throwables.writeAbreviatedClassName((String)"org.spf4j.Class", (Appendable)sb);
        Assert.assertEquals((Object)"o.s.Class", (Object)sb.toString());
        sb = new StringBuilder();
        Throwables.writeAbreviatedClassName((String)"Class", (Appendable)sb);
        Assert.assertEquals((Object)"Class", (Object)sb.toString());
    }

    @Test
    public void testFirst() throws IOException {
        Exception ex = new Exception();
        SQLIntegrityConstraintViolationException sqlEx = new SQLIntegrityConstraintViolationException();
        SQLException sex = new SQLException();
        sex.setNextException(sqlEx);
        ex.addSuppressed(sex);
        Throwable first = Throwables.first((Throwable)ex, t -> t instanceof SQLIntegrityConstraintViolationException);
        Assert.assertSame((Object)sqlEx, (Object)first);
    }
}

