/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import java.math.BigInteger;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.spf4j.base.TimeSource;
import org.spf4j.base.Timing;
import org.spf4j.test.log.TestUtils;

public class TimingTest {
    @Test
    public void testTiming() {
        Assume.assumeFalse((boolean)TestUtils.isExecutedInTravis());
        long nanoTime = TimeSource.nanoTime();
        Instant inst = Instant.now();
        Timing currentTiming = Timing.getCurrentTiming();
        long currNanos = TimeSource.nanoTime();
        long currMillis = System.currentTimeMillis();
        long millisInTheFutureCalculated = currentTiming.fromNanoTimeToEpochMillis(currNanos + TimeUnit.MILLISECONDS.toNanos(10L));
        Assert.assertTrue((currMillis + 10L - millisInTheFutureCalculated <= 1L ? 1 : 0) != 0);
        long fromEpochMillisToNanoTime = currentTiming.fromEpochMillisToNanoTime(Long.MAX_VALUE);
        Assert.assertTrue((fromEpochMillisToNanoTime - TimeSource.nanoTime() > 0L ? 1 : 0) != 0);
        currNanos = TimeSource.nanoTime();
        long nanoTimeIn100ms = currentTiming.fromEpochMillisToNanoTime(System.currentTimeMillis() + 100L);
        long expectNanoTimeIn100ms = currNanos + TimeUnit.MILLISECONDS.toNanos(100L);
        Assert.assertTrue((String)("expected = " + expectNanoTimeIn100ms + ", actual =" + nanoTimeIn100ms), (Math.abs(expectNanoTimeIn100ms - nanoTimeIn100ms) < TimeUnit.MILLISECONDS.toNanos(1L) ? 1 : 0) != 0);
        Instant instant = currentTiming.fromNanoTimeToInstant(nanoTime);
        BigInteger oneMil = BigInteger.valueOf(1000000000L);
        BigInteger i1 = BigInteger.valueOf(instant.getEpochSecond()).multiply(oneMil).add(BigInteger.valueOf(instant.getNano()));
        BigInteger i2 = BigInteger.valueOf(inst.getEpochSecond()).multiply(oneMil).add(BigInteger.valueOf(inst.getNano()));
        BigInteger diff = i2.subtract(i1).abs();
        Assert.assertTrue((String)("Diff is " + diff), (diff.compareTo(BigInteger.valueOf(2000000L)) < 0 ? 1 : 0) != 0);
    }
}

