/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Objects;
import org.spf4j.base.Runtime;
import org.spf4j.base.Version;

public class VersionTest {
    private static final Logger LOG = LoggerFactory.getLogger(VersionTest.class);

    @Test
    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    public void testVersion() {
        Version version1 = new Version("1.u1.3");
        Version version2 = new Version("1.u10.3");
        Assert.assertTrue((version1.compareTo(version2) < 0 ? 1 : 0) != 0);
        LOG.debug("version1 = {}", (Object)version1);
        Assert.assertEquals((Object)3, (Object)version1.getComponents()[3]);
        Version javaVersion = new Version(Runtime.JAVA_VERSION);
        LOG.debug("version1 = {}, image = {}", (Object)javaVersion, (Object)javaVersion.getImage());
        Assert.assertTrue((javaVersion.compareTo(new Version("1.6.0_1")) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVersion2() {
        Version version1 = new Version("1.1");
        Version version2 = new Version("1.1.2");
        Assert.assertTrue((version1.compareTo(version2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVersion3() {
        Version version1 = new Version("1.8.1");
        Version version2 = new Version("1.8.0.25p");
        Assert.assertTrue((version1.compareTo(version2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((version2.compareTo(version1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVersion4() {
        Version version = new Version(Runtime.JAVA_VERSION);
        Assert.assertTrue((version.getMajor() > 0 ? 1 : 0) != 0);
        Version clone = (Version)Objects.clone((Serializable)version);
        Assert.assertEquals((Object)version, (Object)clone);
    }

    @Test
    public void testVersion5() {
        Version version1 = new Version("1.8.1");
        Version version2 = new Version("1.8.2-SNAPSHOT");
        Assert.assertTrue((version1.compareTo(version2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVersion6() {
        Version version1 = new Version("1.8.2");
        Version version2 = new Version("1.8.2-SNAPSHOT");
        Assert.assertTrue((version1.compareTo(version2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((version2.compareTo(version1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVersion7() {
        Version version1 = new Version("1.8.3-SNAPSHOT");
        Version version2 = new Version("1.8.2-SNAPSHOT");
        Assert.assertTrue((version1.compareTo(version2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((version2.compareTo(version1) < 0 ? 1 : 0) != 0);
    }
}

