/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.concurrent.CompoundSemaphore;
import org.spf4j.concurrent.LocalSemaphore;
import org.spf4j.concurrent.Semaphore;
import org.spf4j.failsafe.RateLimiter;

public class CompoundSemaphoreTest {
    @Test
    public void testCompoundSemaphore() throws InterruptedException, TimeoutException {
        try (RateLimiter rateLimiter = new RateLimiter(1L, Duration.ofSeconds(1L), 2L);){
            CompoundSemaphore sem = new CompoundSemaphore(new Semaphore[]{rateLimiter.toSemaphore(), new LocalSemaphore(2, false)});
            sem.acquire(2, 4L, TimeUnit.SECONDS);
            sem.release(2);
            sem.acquire(2, 4L, TimeUnit.SECONDS);
            sem.release(2);
            sem.acquire(2, 4L, TimeUnit.SECONDS);
            sem.release(2);
            Assert.assertEquals((long)2L, (long)sem.getSemaphores().length);
        }
    }
}

