/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Pair;
import org.spf4j.base.Throwables;
import org.spf4j.concurrent.Futures;
import org.spf4j.concurrent.LifoThreadPoolExecutorSQP;

public class LifoThreadPoolExecutorSTest {
    private static final Logger LOG = LoggerFactory.getLogger(LifoThreadPoolExecutorSTest.class);

    @Test
    public void testLifoExecSQ() throws Exception {
        LifoThreadPoolExecutorSQP executor = new LifoThreadPoolExecutorSQP("test", 2, 8, 10000, 1024);
        LifoThreadPoolExecutorSTest.assertTestPoolBehavior((ExecutorService)executor);
    }

    @Test
    @Ignore
    @SuppressFBWarnings(value={"HES_LOCAL_EXECUTOR_SERVICE"})
    public void testJdkExec() throws Exception {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(1024);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(8, 8, 60000L, TimeUnit.MILLISECONDS, linkedBlockingQueue);
        LifoThreadPoolExecutorSTest.assertTestPoolBehavior(executor);
    }

    public static void assertTestPoolBehavior(ExecutorService executor) throws Exception {
        final LongAdder adder = new LongAdder();
        int testCount = 20000;
        long rejected = 0L;
        Runnable runnable = new Runnable(){

            @Override
            @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
            public void run() {
                adder.increment();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex) {
                    Throwables.writeTo((Throwable)ex, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
                }
            }
        };
        long start = System.currentTimeMillis();
        ArrayList futures = new ArrayList(20000);
        for (int i = 0; i < 20000; ++i) {
            try {
                futures.add(executor.submit(runnable));
                continue;
            }
            catch (RejectedExecutionException ex) {
                ++rejected;
                runnable.run();
            }
        }
        Pair results = Futures.getAll((long)60000L, futures);
        Exception second = (Exception)results.getSecond();
        if (second != null) {
            throw second;
        }
        executor.shutdown();
        boolean awaitTermination = executor.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        LOG.debug("Stats for {}, rejected = {}, Exec time = {}", new Object[]{executor.getClass(), rejected, System.currentTimeMillis() - start});
        Assert.assertTrue((boolean)awaitTermination);
        Assert.assertEquals((long)20000L, (long)adder.sum());
    }
}

