/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.AtomicSequence;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.concurrent.ScalableSequence;
import org.spf4j.concurrent.Sequence;

public final class SequenceTest {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceTest.class);

    @Test
    public void testSequence() throws InterruptedException, ExecutionException {
        if (Runtime.NR_PROCESSORS <= 4) {
            return;
        }
        this.testSeq((Sequence)new AtomicSequence(0L));
        this.testSeq((Sequence)new ScalableSequence(0L, 100));
        long seq1 = this.testSeq((Sequence)new AtomicSequence(0L));
        long seq2 = this.testSeq((Sequence)new ScalableSequence(0L, 100));
        Assert.assertTrue((String)("Should be " + seq2 + " >= " + seq1), (seq2 >= seq1 ? 1 : 0) != 0);
    }

    public long testSeq(Sequence sequence) throws InterruptedException, ExecutionException {
        Future[] futures = new Future[Runtime.NR_PROCESSORS];
        for (int i = 0; i < Runtime.NR_PROCESSORS; ++i) {
            futures[i] = DefaultExecutor.INSTANCE.submit(() -> {
                long last = -1L;
                for (int i1 = 0; i1 < 100000; ++i1) {
                    last = sequence.next();
                }
                return last;
            });
        }
        long seq = 0L;
        for (Future future : futures) {
            long ls = (Long)future.get();
            if (ls > seq) {
                seq = ls;
            }
            LOG.debug("Seq {}: {}", sequence.getClass(), (Object)ls);
        }
        return seq;
    }
}

