/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.TimeSource;
import org.spf4j.failsafe.RetryPolicy;

public class SyncRetryExecutorTest {
    private static final Logger LOG = LoggerFactory.getLogger(SyncRetryExecutorTest.class);

    @Test
    public void testExHandling() throws InterruptedException, TimeoutException {
        try {
            RetryPolicy.defaultPolicy().run(() -> {
                throw new RuntimeException("fail");
            }, RuntimeException.class, TimeSource.nanoTime() - 10000000L);
            Assert.fail();
        }
        catch (RuntimeException ex) {
            LOG.debug("Expected exception", (Throwable)ex);
            Assert.assertEquals((Object)"fail", (Object)ex.getMessage());
        }
    }

    @Test
    public void testExHandling2() throws InterruptedException {
        try {
            RetryPolicy.defaultPolicy().async().submit(() -> {
                throw new RuntimeException("fail");
            }, TimeSource.nanoTime() - 10000000L).get();
            Assert.fail();
        }
        catch (ExecutionException ex) {
            LOG.debug("Expected exception", (Throwable)ex);
            Throwable t = ex.getCause();
            Assert.assertEquals((Object)"fail", (Object)t.getMessage());
        }
    }
}

