/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.TimeSource;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.failsafe.RetryPolicy;
import org.spf4j.failsafe.RetryPredicate;
import org.spf4j.failsafe.concurrent.FailSafeExecutorImpl;
import org.spf4j.log.Level;
import org.spf4j.test.log.annotations.ExpectLog;

@SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
public class RetryExecutorTest {
    private static final Logger LOG = LoggerFactory.getLogger(RetryExecutorTest.class);

    @Test
    @ExpectLog(category="org.spf4j.failsafe.concurrent.RetryExecutorTest", level=Level.DEBUG, nrTimes=3, messageRegexp="Executing .*")
    public void testHedgedretryExecution() throws InterruptedException, ExecutionException {
        try (FailSafeExecutorImpl exec = new FailSafeExecutorImpl(DefaultExecutor.INSTANCE);){
            Future fut = exec.submit(() -> {
                LOG.debug("Executing {}", (Object)this);
                return Thread.currentThread().getName();
            }, RetryPredicate.NORETRY, 2, 0L, TimeUnit.MILLISECONDS);
            Assert.assertNotNull(fut.get());
        }
    }

    @Test
    @ExpectLog(category="org.spf4j.failsafe.concurrent.RetryExecutorTest", level=Level.DEBUG, nrTimes=1, messageRegexp="Executing .*")
    public void testHedgedretryExecution2() throws InterruptedException, ExecutionException {
        try (FailSafeExecutorImpl exec = new FailSafeExecutorImpl(DefaultExecutor.INSTANCE);){
            Future fut = exec.submit(() -> {
                LOG.debug("Executing {}", (Object)this);
                return Thread.currentThread().getName();
            }, RetryPredicate.NORETRY, 2, 1000L, TimeUnit.MILLISECONDS);
            Assert.assertNotNull(fut.get());
        }
    }

    @Test(expected=ExecutionException.class)
    public void testHedgedretryExecution3() throws InterruptedException, ExecutionException {
        try (FailSafeExecutorImpl exec = new FailSafeExecutorImpl(DefaultExecutor.INSTANCE);){
            Future fut = exec.submit(() -> {
                throw new RuntimeException();
            }, RetryPredicate.NORETRY, 2, 10L, TimeUnit.MILLISECONDS);
            Assert.assertNotNull(fut.get());
        }
    }

    @Test(timeout=1000L)
    public void testHedgedretryExecution4() throws InterruptedException, ExecutionException {
        AtomicInteger ai = new AtomicInteger();
        try (FailSafeExecutorImpl exec = new FailSafeExecutorImpl(DefaultExecutor.INSTANCE);){
            long nanoTime = TimeSource.nanoTime();
            Future fut = exec.submit(() -> {
                if (ai.getAndIncrement() == 0) {
                    Thread.sleep(1000000L);
                    return "B";
                }
                LOG.debug("Executing {}", (Object)this);
                return "A";
            }, RetryPolicy.defaultPolicy().getRetryPredicate(nanoTime, nanoTime + 1000000000L), 2, 10L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)"A", fut.get());
        }
    }
}

