/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.io.AppendableLimiterWithOverflow;

public class AppendableLimiterWithFileOverflowTest {
    private static final Logger LOG = LoggerFactory.getLogger(AppendableLimiterWithFileOverflowTest.class);
    private static final String TEST_STR = "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";

    @Test
    public void testOverflowX() throws IOException {
        this.testOverflowByX(90, TEST_STR, 0, new StringBuilder());
        this.testOverflowByX(90, TEST_STR, 8, new StringBuilder());
        this.testOverflowByX(90, TEST_STR, 13, new StringBuilder());
        this.testOverflowByX(90, TEST_STR, 88, new StringBuilder());
        this.testOverflowByX(90, TEST_STR, 90, new StringBuilder());
        this.testOverflowByX(TEST_STR.length(), TEST_STR, 45, new StringBuilder());
        this.testOverflowByX(90, TEST_STR, 0, new StringWriter());
        this.testOverflowByX(90, TEST_STR, 8, new StringWriter());
        this.testOverflowByX(90, TEST_STR, 13, new StringWriter());
        this.testOverflowByX(90, TEST_STR, 88, new StringWriter());
        this.testOverflowByX(90, TEST_STR, 90, new StringWriter());
        this.testOverflowByX(TEST_STR.length(), TEST_STR, 45, new StringWriter());
    }

    private void testOverflowByX(int limit, String testStr, int splitIdx, Appendable destination) throws IOException {
        File ovflow = File.createTempFile("overflow", ".txt");
        LOG.debug("Destination file: {}", (Object)ovflow.getPath());
        try (AppendableLimiterWithOverflow limiter = new AppendableLimiterWithOverflow(limit, ovflow, (CharSequence)"...@", StandardCharsets.UTF_8, destination);){
            limiter.append(testStr.subSequence(0, splitIdx));
            limiter.append(testStr.charAt(splitIdx));
            limiter.append(testStr.subSequence(splitIdx + 1, testStr.length()));
        }
        LOG.debug("Result: {}", (Object)destination);
        String destinationStr = destination.toString();
        Assert.assertEquals((long)limit, (long)destinationStr.length());
        String suffix = "...@" + ovflow.getPath();
        if (limit < testStr.length()) {
            Assert.assertThat((Object)destinationStr, (Matcher)Matchers.endsWith((String)suffix));
            int strWritten = 90 - suffix.length();
            Assert.assertEquals((Object)testStr.substring(0, strWritten), (Object)destinationStr.substring(0, strWritten));
            String oContent = CharStreams.toString((Readable)new InputStreamReader(Files.newInputStream(ovflow.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            Assert.assertEquals((Object)testStr, (Object)oContent);
        } else {
            Assert.assertEquals((Object)testStr, (Object)destinationStr);
            String oContent = CharStreams.toString((Readable)new InputStreamReader(Files.newInputStream(ovflow.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            Assert.assertEquals((Object)"", (Object)oContent);
        }
    }
}

