/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.compress;

import com.google.common.io.FileWriteMode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.io.compress.Compress;

public class CompressTest {
    @Test
    public void testZip() throws IOException {
        File tmpFolder = com.google.common.io.Files.createTempDir();
        File file = File.createTempFile(".bla", ".tmp", tmpFolder);
        String testStr = "skjfghskjdhgfjgishfgksjhgjkhdskghsfdkjhg";
        File subFolder = new File(file.getParent(), "subFolder");
        if (!subFolder.mkdir()) {
            throw new IOException("Cannot create folder " + subFolder);
        }
        File subTestFile = new File(subFolder, "subTestFile.txt");
        com.google.common.io.Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)testStr);
        com.google.common.io.Files.asCharSink((File)subTestFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)testStr);
        Path zip = Compress.zip((Path)tmpFolder.toPath());
        Assert.assertThat((Object)zip.getFileName().toString(), (Matcher)Matchers.endsWith((String)".zip"));
        Assert.assertTrue((boolean)Files.exists(zip, new LinkOption[0]));
        File tmpFir = com.google.common.io.Files.createTempDir();
        List unzip = Compress.unzip((Path)zip, (Path)tmpFir.toPath());
        Assert.assertEquals((long)2L, (long)unzip.size());
        Assert.assertEquals((Object)testStr, (Object)com.google.common.io.Files.asCharSource((File)((Path)unzip.get(0)).toFile(), (Charset)StandardCharsets.UTF_8).read());
        Assert.assertEquals((Object)testStr, (Object)com.google.common.io.Files.asCharSource((File)((Path)unzip.get(1)).toFile(), (Charset)StandardCharsets.UTF_8).read());
    }

    @Test
    public void testZip2() throws IOException {
        File file = File.createTempFile(".bla", ".tmp");
        String testStr = "skjfghskjdhgfjgishfgksjhgjkhdskghsfdkjhg";
        com.google.common.io.Files.write((CharSequence)testStr, (File)file, (Charset)StandardCharsets.UTF_8);
        Path zip = Compress.zip((Path)file.toPath());
        Assert.assertThat((Object)zip.getFileName().toString(), (Matcher)Matchers.endsWith((String)".zip"));
        Assert.assertTrue((boolean)Files.exists(zip, new LinkOption[0]));
        File tmpFir = com.google.common.io.Files.createTempDir();
        List unzip = Compress.unzip((Path)zip, (Path)tmpFir.toPath());
        Assert.assertEquals((long)1L, (long)unzip.size());
        Assert.assertEquals((Object)testStr, (Object)com.google.common.io.Files.toString((File)((Path)unzip.get(0)).toFile(), (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testZipX() throws IOException {
        File tmpFolder = com.google.common.io.Files.createTempDir();
        File file = File.createTempFile(".bla", ".tmp", tmpFolder);
        String testStr = "skjfghskjdhgfjgishfgksjhgjkhdskghsfdkjhg";
        File subFolder = new File(file.getParent(), "subFolder");
        if (!subFolder.mkdir()) {
            throw new IOException("Cannot create folder " + subFolder);
        }
        File subTestFile = new File(subFolder, "subTestFile.txt");
        com.google.common.io.Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)testStr);
        com.google.common.io.Files.asCharSink((File)subTestFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)testStr);
        Path zip = Compress.zip((Path)tmpFolder.toPath());
        Assert.assertThat((Object)zip.getFileName().toString(), (Matcher)Matchers.endsWith((String)".zip"));
        Assert.assertTrue((boolean)Files.exists(zip, new LinkOption[0]));
        File tmpFir = com.google.common.io.Files.createTempDir();
        List unzip = Compress.unzip2((Path)zip, (Path)tmpFir.toPath());
        Assert.assertEquals((long)2L, (long)unzip.size());
        Assert.assertEquals((Object)testStr, (Object)com.google.common.io.Files.asCharSource((File)((Path)unzip.get(0)).toFile(), (Charset)StandardCharsets.UTF_8).read());
        Assert.assertEquals((Object)testStr, (Object)com.google.common.io.Files.asCharSource((File)((Path)unzip.get(1)).toFile(), (Charset)StandardCharsets.UTF_8).read());
    }

    @Test
    public void testZipX2() throws IOException {
        File file = File.createTempFile(".bla", ".tmp");
        String testStr = "skjfghskjdhgfjgishfgksjhgjkhdskghsfdkjhg";
        com.google.common.io.Files.write((CharSequence)testStr, (File)file, (Charset)StandardCharsets.UTF_8);
        Path zip = Compress.zip((Path)file.toPath());
        Assert.assertThat((Object)zip.getFileName().toString(), (Matcher)Matchers.endsWith((String)".zip"));
        Assert.assertTrue((boolean)Files.exists(zip, new LinkOption[0]));
        File tmpFir = com.google.common.io.Files.createTempDir();
        List unzip = Compress.unzip2((Path)zip, (Path)tmpFir.toPath());
        Assert.assertEquals((long)1L, (long)unzip.size());
        Assert.assertEquals((Object)testStr, (Object)com.google.common.io.Files.toString((File)((Path)unzip.get(0)).toFile(), (Charset)StandardCharsets.UTF_8));
    }
}

