/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Runtime;
import org.spf4j.base.Throwables;
import org.spf4j.jmx.Client;
import org.spf4j.jmx.DynamicMBeanBuilder;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.PropertySource;
import org.spf4j.jmx.Registry;
import org.spf4j.jmx.Test;
import org.spf4j.jmx.TestBean;
import org.spf4j.jmx.TestEnum;
import org.spf4j.tsdb2.avro.ColumnDef;
import org.spf4j.tsdb2.avro.TableDef;
import org.spf4j.tsdb2.avro.Type;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
public final class RegistryTest {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryTest.class);

    @org.junit.Test
    public void testRegistry() throws InterruptedException, IOException, InstanceNotFoundException, MBeanException, AttributeNotFoundException, ReflectionException, InvalidAttributeValueException {
        JmxTest testObj = new JmxTest();
        Properties props = new Properties();
        props.setProperty("propKey", "propvalue");
        Registry.export((String)"caca", (String)"maca", (Properties)props, (Object[])new Object[0]);
        Registry.export((String)"test", (String)"Test", (Properties)props, (Object[])new Object[]{testObj});
        Registry.registerMBean((String)"test2", (String)"TestClassic", (Object)new Test());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isCrap", Boolean.TRUE);
        map.put("a.crap", Boolean.FALSE);
        map.put("isNonsense", "bla");
        map.put("", "bla");
        Registry.export((String)"testMap", (String)"map", map, (Object[])new Object[]{testObj});
        Client.setAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"booleanFlag", (Object)Boolean.TRUE);
        Client.setAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"propKey", (Object)"caca");
        Object ret = Client.getAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"booleanFlag");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ret);
        String prop = (String)Client.getAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"propKey");
        Assert.assertEquals((Object)"caca", (Object)prop);
        Assert.assertEquals((Object)"caca", (Object)props.get("propKey"));
        CompositeData cd = (CompositeData)Client.getAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"columnDef");
        LOG.debug("CD={}", (Object)cd);
        Assert.assertEquals((Object)"bla", (Object)cd.get("name"));
        CompositeData cd2 = (CompositeData)Client.callOperation((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"getColumnDef", (Object[])new Object[]{"bubu"});
        LOG.debug("CD2={}", (Object)cd2);
        Assert.assertEquals((Object)"bubu", (Object)cd2.get("name"));
        CompositeData cd3 = (CompositeData)Client.callOperation((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"echo", (Object[])new Object[]{cd2});
        LOG.debug("CD3={}", (Object)cd3);
        Assert.assertEquals((Object)"bubu", (Object)cd3.get("name"));
        Client.callOperation((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"print", (Object[])new Object[]{3, Boolean.TRUE, "caca", cd2});
        Client.setAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"stringVal", (Object)"bla bla");
        Object ret2 = Client.getAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"stringVal");
        Assert.assertEquals((Object)"bla bla", (Object)ret2);
        try {
            Client.setAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"doubleVal", (Object)0.0);
            Assert.fail();
        }
        catch (RuntimeMBeanException e) {
            Throwables.writeTo((Throwable)e, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
        }
    }

    @org.junit.Test
    @SuppressFBWarnings(value={"UMAC_UNCALLABLE_METHOD_OF_ANONYMOUS_CLASS"})
    public void testRegistry2() throws IOException, JMException {
        JmxTest testObj = new JmxTest();
        JmxTest2 testObj2 = new JmxTest2();
        Registry.unregister((String)"test", (String)"Test");
        Registry.export((String)"test", (String)"Test", (Object[])new Object[]{testObj, testObj2});
        Registry.export((String)"test", (String)"TestStatic", (Object[])new Object[]{JmxTest2.class});
        Client.setAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"booleanFlag", (Object)Boolean.TRUE);
        Object ret = Client.getAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"booleanFlag");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ret);
        new DynamicMBeanBuilder().withJmxExportObject(new Object(){

            @JmxExport(value="customName")
            @SuppressFBWarnings(value={"UMAC_UNCALLABLE_METHOD_OF_ANONYMOUS_CLASS"})
            public int getMyValue() {
                return 13;
            }
        }).extend("test", "Test");
        Object retCustom = Client.getAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"customName");
        Assert.assertEquals((Object)13, (Object)retCustom);
        Client.setAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"stringVal", (Object)"bla bla");
        Object ret2 = Client.getAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"stringVal");
        Assert.assertEquals((Object)"bla bla", (Object)ret2);
        try {
            Client.setAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"doubleVal", (Object)0.0);
            Assert.fail();
        }
        catch (RuntimeMBeanException e) {
            Throwables.writeTo((Throwable)e, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.NONE);
        }
        testObj2.setStringVal("cucu");
        Object ret3 = Client.getAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"stringVal2");
        Assert.assertEquals((Object)"cucu", (Object)ret3);
        JmxTest2.setTestStr("bubu");
        Object ret4 = Client.getAttribute((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"testStr");
        Assert.assertEquals((Object)"bubu", (Object)ret4);
        Object ret5 = Client.callOperation((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)"test", (String)"Test", (String)"doStuff", (Object[])new Object[]{"a", "b"});
        Assert.assertEquals((Object)"Doing a b", (Object)ret5);
    }

    @org.junit.Test
    public void testClassLocator() throws IOException, InstanceNotFoundException, MBeanException, ReflectionException {
        Registry.export(Runtime.Jmx.class);
        CompositeData info = (CompositeData)Client.callOperation((String)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String)Runtime.Jmx.class.getPackage().getName(), (String)Runtime.Jmx.class.getSimpleName(), (String)"getPackageInfo", (Object[])new Object[]{Registry.class.getName()});
        LOG.debug("Returned {}", (Object)info);
        Assert.assertNotNull((Object)info);
    }

    public static final class JmxTest2 {
        private static volatile String testStr;
        private volatile String stringVal;

        @JmxExport(value="stringVal2")
        public String getStringVal() {
            return this.stringVal;
        }

        @JmxExport(value="stringVal2")
        public void setStringVal(String stringVal) {
            this.stringVal = stringVal;
        }

        @JmxExport
        public static String getTestStr() {
            return testStr;
        }

        public static void setTestStr(String testStr) {
            JmxTest2.testStr = testStr;
        }

        @JmxExport(description="test operation")
        public String doStuff(@JmxExport(value="what", description="some param") String what, String where) {
            return "Doing " + what + " " + where;
        }
    }

    public static final class JmxTest
    extends PropertySource {
        private volatile String stringVal;
        private volatile double doubleVal;
        private volatile boolean booleanFlag;
        private final String[][] matrix = new String[][]{{"a", "b"}, {"c", "d"}};
        private volatile TestEnum enumVal = TestEnum.VAL2;
        private final TestBean bean = new TestBean(3, "bla");
        private final String[] array = new String[]{"a", "b"};

        @JmxExport
        public String[][] getMatrix() {
            return (String[][])this.matrix.clone();
        }

        @JmxExport
        public String[] getArray() {
            return (String[])this.array.clone();
        }

        @JmxExport
        public String getStringVal() {
            return this.stringVal;
        }

        @JmxExport
        public double getDoubleVal() {
            return this.doubleVal;
        }

        @JmxExport
        public boolean isBooleanFlag() {
            return this.booleanFlag;
        }

        @JmxExport
        public Boolean isBooleanFlag2() {
            return this.booleanFlag;
        }

        @JmxExport
        public void setStringVal(String stringVal) {
            this.stringVal = stringVal;
        }

        @JmxExport
        public void setBooleanFlag(boolean booleanFlag) {
            this.booleanFlag = booleanFlag;
        }

        public void setDoubleVal(double doubleVal) {
            this.doubleVal = doubleVal;
        }

        @JmxExport
        public TestEnum getEnumVal() {
            return this.enumVal;
        }

        @JmxExport
        public void setEnumVal(TestEnum enumVal) {
            this.enumVal = enumVal;
        }

        @JmxExport
        public TestBean getBean() {
            return this.bean;
        }

        @JmxExport
        @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
        public File getFile() {
            return new File("/tmp");
        }

        @Override
        @JmxExport
        public String getProperty(String name) {
            return "bla";
        }

        @Override
        @JmxExport
        public void setProperty(String name, String value) {
        }

        @JmxExport
        public ColumnDef getColumnDef() {
            return ColumnDef.newBuilder().setName("bla").setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build();
        }

        @JmxExport
        public TableDef getTableDef() {
            return TableDef.newBuilder().setId(4L).setDescription("bla").setName("name").setSampleTime(10).setColumns(Collections.singletonList(ColumnDef.newBuilder().setName("bla").setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build())).build();
        }

        @JmxExport
        public ColumnDef getColumnDef(String id) {
            return ColumnDef.newBuilder().setName(id).setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build();
        }

        @JmxExport
        public ColumnDef echo(ColumnDef id) {
            return id;
        }

        @JmxExport
        public List<ColumnDef> echoX(List<ColumnDef> id) {
            return id;
        }

        @JmxExport
        @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
        public List<ColumnDef> getListAttr() {
            return Arrays.asList(ColumnDef.newBuilder().setName("bla").setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build(), ColumnDef.newBuilder().setName("bla2").setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build());
        }

        @JmxExport
        @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
        public Map<String, ColumnDef> getMapAttr() {
            return ImmutableMap.of((Object)"k1", (Object)ColumnDef.newBuilder().setName("bla").setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build(), (Object)"K2", (Object)ColumnDef.newBuilder().setName("bla2").setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build());
        }

        @JmxExport
        public Map<String, ColumnDef> echoXY(Map<String, ColumnDef> id) {
            return id;
        }

        @JmxExport(value="echo2", description="bla bla bla")
        public File echo(File id) {
            return id;
        }

        @JmxExport
        public void print(int nr, boolean flag, String bla, ColumnDef id) {
            LOG.info("{}, {}, {}, {}", new Object[]{bla, nr, flag, id});
        }
    }
}

