/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.net;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketTimeoutException;
import java.time.Instant;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.NotThreadSafe;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.failsafe.RetryPolicy;
import org.spf4j.net.SntpClient;
import org.spf4j.net.Timing;

@NotThreadSafe
public final class SntpClientTest {
    private static final Logger LOG = LoggerFactory.getLogger(SntpClientTest.class);

    @Test
    public void test() throws IOException, InterruptedException, TimeoutException {
        Timing requestTime = SntpClient.requestTimeHA((int)60000, (String[])new String[]{"time.apple.com"});
        long currentTimeMachine = System.currentTimeMillis();
        long currentTimeNtp = requestTime.getTime();
        LOG.debug("Current time machine = {} ", (Object)Instant.ofEpochMilli(currentTimeMachine));
        LOG.debug("Current time ntp = {} ", (Object)Instant.ofEpochMilli(currentTimeNtp));
        Assert.assertTrue((Math.abs(currentTimeNtp - currentTimeMachine) < 10000L ? 1 : 0) != 0);
    }

    @Test
    public void test2() throws IOException {
        try (Closeable runUdpServer = SntpClientTest.runUdpServer(false);){
            Timing timing = SntpClient.requestTime((String)"localhost", (int)50123, (int)20);
            long currentTimeMachine = System.currentTimeMillis();
            long currentTimeNtp = timing.getTime();
            LOG.debug("Current Timing = {} ", (Object)timing);
            LOG.debug("Current time machine = {} ", (Object)Instant.ofEpochMilli(currentTimeMachine));
            LOG.debug("Current time ntp = {} ", (Object)Instant.ofEpochMilli(currentTimeNtp));
            Assert.assertTrue((Math.abs(currentTimeNtp - currentTimeMachine) < 10000L ? 1 : 0) != 0);
        }
    }

    @Test
    public void test2h() throws IOException, InterruptedException, TimeoutException {
        try (Closeable runUdpServer = SntpClientTest.runUdpServer(true);){
            Timing timing = SntpClient.requestTimeHA((int)60000, (int)5, (int)50123, (String[])new String[]{"localhost"});
            long currentTimeMachine = System.currentTimeMillis();
            long currentTimeNtp = timing.getTime();
            LOG.debug("Current Timing = {} ", (Object)timing);
            LOG.debug("Current time machine = {} ", (Object)Instant.ofEpochMilli(currentTimeMachine));
            LOG.debug("Current time ntp = {} ", (Object)Instant.ofEpochMilli(currentTimeNtp));
            Assert.assertTrue((Math.abs(currentTimeNtp - currentTimeMachine) < 10000L ? 1 : 0) != 0);
        }
    }

    @Test
    public void test3() {
        byte[] buffer = new byte[8];
        long currentTimeMillis = 1530813879198L;
        SntpClient.writeTimeStamp((byte[])buffer, (int)0, (long)currentTimeMillis);
        long readTimeStamp = SntpClient.readTimeStamp((byte[])buffer, (int)0);
        Assert.assertTrue((Math.abs(currentTimeMillis - readTimeStamp) < 2L ? 1 : 0) != 0);
    }

    public static Closeable runUdpServer(final boolean hickup) {
        return new Closeable(){
            private volatile boolean terminated = false;
            private Future<?> server = DefaultExecutor.INSTANCE.submit((Runnable)new AbstractRunnable(true){

                @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
                public void doRun() throws IOException, InterruptedException, TimeoutException {
                    boolean first = true;
                    try (DatagramSocket socket = (DatagramSocket)RetryPolicy.defaultPolicy().call(() -> new DatagramSocket(50123), IOException.class, 2L, TimeUnit.MINUTES);){
                        socket.setSoTimeout(1000);
                        byte[] buffer = new byte[48];
                        DatagramPacket request = new DatagramPacket(buffer, buffer.length);
                        while (!terminated) {
                            try {
                                socket.receive(request);
                            }
                            catch (SocketTimeoutException sex) {
                                continue;
                            }
                            long currentTimeMillis = System.currentTimeMillis();
                            LOG.debug("Server received {}", (Object)buffer);
                            if (first && hickup) {
                                Thread.sleep(1000L);
                                first = false;
                            }
                            DatagramPacket response = new DatagramPacket(buffer, buffer.length, request.getAddress(), request.getPort());
                            buffer[0] = 28;
                            buffer[1] = 2;
                            SntpClient.writeTimeStamp((byte[])buffer, (int)32, (long)currentTimeMillis);
                            System.arraycopy(buffer, 40, buffer, 24, 8);
                            SntpClient.writeTimeStamp((byte[])buffer, (int)40, (long)System.currentTimeMillis());
                            socket.send(response);
                            LOG.debug("Server reply to {} with {}", (Object)request.getPort(), (Object)buffer);
                        }
                    }
                }
            });

            @Override
            public void close() {
                this.terminated = true;
                this.server.cancel(true);
            }
        };
    }
}

