/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Schema;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.avro.AvroCloseableIterable;
import org.spf4j.perf.CloseableMeasurementRecorder;
import org.spf4j.perf.CloseableMeasurementRecorderSource;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MeasurementStoreQuery;
import org.spf4j.perf.impl.RecorderFactory;
import org.spf4j.tsdb2.avro.Observation;

@SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
public final class RecorderFactoryTest {
    private static final Logger LOG = LoggerFactory.getLogger(RecorderFactoryTest.class);

    @Test
    public void testCreateScalableQuantizedRecorder() throws IOException, InterruptedException {
        String forWhat = "test1";
        String unitOfMeasurement = "ms";
        int sampleTime = 1000;
        int factor = 10;
        int lowerMagnitude = 0;
        int higherMagnitude = 3;
        int quantasPerMagnitude = 10;
        CloseableMeasurementRecorder result = RecorderFactory.createScalableQuantizedRecorder2((Object)forWhat, (String)unitOfMeasurement, (int)sampleTime, (int)factor, (int)lowerMagnitude, (int)higherMagnitude, (int)quantasPerMagnitude);
        for (int i = 0; i < 500; ++i) {
            result.record((long)i);
            Thread.sleep(20L);
        }
        result.close();
        RecorderFactoryTest.assertData(forWhat, 124750L);
        MeasurementStore store = RecorderFactory.MEASUREMENT_STORE;
        MeasurementStoreQuery query = store.query();
        Collection measurements = query.getMeasurements(x -> forWhat.equals(x));
        Schema m = (Schema)measurements.iterator().next();
        try (AvroCloseableIterable observations = query.getObservations(m, Instant.EPOCH, Instant.now());){
            for (Observation o : observations) {
                LOG.debug("RAW Obeservation", (Object)o);
            }
        }
        observations = query.getAggregatedObservations(m, Instant.EPOCH, Instant.now(), 2, TimeUnit.SECONDS);
        var14_15 = null;
        try {
            for (Observation o : observations) {
                LOG.debug("AGG Obeservation", (Object)o);
            }
        }
        catch (Throwable throwable) {
            var14_15 = throwable;
            throw throwable;
        }
        finally {
            if (observations != null) {
                if (var14_15 != null) {
                    try {
                        observations.close();
                    }
                    catch (Throwable throwable) {
                        var14_15.addSuppressed(throwable);
                    }
                } else {
                    observations.close();
                }
            }
        }
    }

    @Test
    public void testCreateScalableQuantizedRecorderSource() throws IOException, InterruptedException {
        String forWhat = "bla";
        String unitOfMeasurement = "ms";
        int sampleTime = 1000;
        int factor = 10;
        int lowerMagnitude = 0;
        int higherMagnitude = 3;
        int quantasPerMagnitude = 10;
        CloseableMeasurementRecorderSource result = RecorderFactory.createScalableQuantizedRecorderSource2((Object)forWhat, (String)unitOfMeasurement, (int)sampleTime, (int)factor, (int)lowerMagnitude, (int)higherMagnitude, (int)quantasPerMagnitude);
        for (int i = 0; i < 5000; ++i) {
            result.getRecorder((Object)("X" + i % 2)).record(1L);
            Thread.sleep(1L);
        }
        result.close();
        RecorderFactoryTest.assertData("bla,X0", 2500L);
    }

    @Test
    public void testOutofQuantizedZoneValues() throws IOException, InterruptedException {
        String forWhat = "largeVals";
        String unitOfMeasurement = "ms";
        int sampleTime = 1000;
        int factor = 10;
        int lowerMagnitude = 0;
        int higherMagnitude = 3;
        int quantasPerMagnitude = 10;
        CloseableMeasurementRecorder result = RecorderFactory.createScalableQuantizedRecorder2((Object)forWhat, (String)unitOfMeasurement, (int)sampleTime, (int)factor, (int)lowerMagnitude, (int)higherMagnitude, (int)quantasPerMagnitude);
        for (int i = 0; i < 500; ++i) {
            result.record(10000L);
            Thread.sleep(20L);
        }
        result.close();
        RecorderFactoryTest.assertData(forWhat, 5000000L);
    }

    @Test
    public void testCreateScalableCountingRecorderSource() throws IOException, InterruptedException {
        String forWhat = "counters";
        String unitOfMeasurement = "counts";
        int sampleTime = 1000;
        CloseableMeasurementRecorderSource result = RecorderFactory.createScalableCountingRecorderSource2((Object)forWhat, (String)unitOfMeasurement, (int)sampleTime);
        for (int i = 0; i < 5000; ++i) {
            result.getRecorder((Object)("X" + i % 2)).record(1L);
            Thread.sleep(1L);
        }
        result.close();
        RecorderFactoryTest.assertData(forWhat + ",X1", 2500L);
    }

    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    public static void assertData(String forWhat, long expectedValue) throws IOException {
        MeasurementStore store = RecorderFactory.MEASUREMENT_STORE;
        store.flush();
        MeasurementStoreQuery query = store.query();
        Collection schemas = query.getMeasurements(x -> forWhat.equals(x));
        Schema schema = (Schema)schemas.iterator().next();
        try (AvroCloseableIterable observations = query.getObservations(schema, Instant.EPOCH, Instant.ofEpochMilli(Long.MAX_VALUE));){
            long sum = 0L;
            for (Observation o : observations) {
                sum += ((Long)o.getData().get(0)).longValue();
            }
            Assert.assertEquals((long)expectedValue, (long)sum);
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        new RecorderFactoryTest().testCreateScalableQuantizedRecorder();
    }
}

