/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.pool.jdbc;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.tools.Server;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.pool.jdbc.JdbcConnectionFactory;
import org.spf4j.pool.jdbc.PooledDataSource;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.RecyclingSupplier;

public class PooledDataSourceTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionPool() throws SQLException, ObjectCreationException, IOException {
        Server server = Server.createTcpServer((String[])new String[]{"-tcpPort", "9123", "-tcpAllowOthers"}).start();
        try {
            File tempDB = File.createTempFile("test", "h2db");
            String connStr = "jdbc:h2:tcp://localhost:9123/nio:" + tempDB.getAbsolutePath() + ";AUTO_SERVER=TRUE";
            PooledDataSource pds = new PooledDataSource(1, 2, (RecyclingSupplier.Factory)new JdbcConnectionFactory("org.h2.Driver", connStr, "sa", "sa"));
            try (Connection conn = pds.getConnection();){
                Assert.assertTrue((boolean)conn.isValid(10));
            }
        }
        finally {
            server.stop();
        }
    }
}

