/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Either;
import org.spf4j.recyclable.BlockingDisposable;
import org.spf4j.recyclable.ObjectBorower;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.Scanable;
import org.spf4j.recyclable.impl.SimpleSmartObjectPool;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
public final class SimpleSmartObjectPoolTest
implements ObjectBorower<TestObject> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleSmartObjectPoolTest.class);
    private TestObject borowedObject = null;
    private final SimpleSmartObjectPool<TestObject> instance = new SimpleSmartObjectPool(2, 10, (RecyclingSupplier.Factory)new RecyclingSupplier.Factory<TestObject>(){

        public TestObject create() {
            TestObject obj = new TestObject("Object");
            LOG.debug("Created {}", (Object)obj);
            return obj;
        }

        public void dispose(TestObject object) throws ObjectDisposeException {
            try {
                LOG.debug("Disposing Object {}", (Object)object);
                object.dispose();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }

        public boolean validate(TestObject object, Exception e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }, true);

    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
    public Either<ObjectBorower.Action, TestObject> tryRequestReturnObject() {
        if (this.borowedObject != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            this.instance.recycle((Object)this.borowedObject, (ObjectBorower)this);
        }
        return Either.left((Object)ObjectBorower.Action.NONE);
    }

    public TestObject tryReturnObjectIfNotInUse() {
        return this.borowedObject;
    }

    public boolean scan(Scanable.ScanHandler<TestObject> handler) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<TestObject> tryReturnObjectsIfNotNeededAnymore() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<TestObject> tryReturnObjectsIfNotInUse() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean nevermind(TestObject object) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Test
    public void testPool() throws InterruptedException, TimeoutException, ObjectCreationException, ObjectDisposeException {
        this.borowedObject = (TestObject)this.instance.get((ObjectBorower)this);
        Assert.assertNotNull((Object)this.borowedObject);
        this.instance.recycle((Object)this.borowedObject, (ObjectBorower)this);
        this.instance.dispose();
    }

    public static final class TestObject
    implements BlockingDisposable {
        private boolean disposed = false;
        private final String data;

        public TestObject(String data) {
            this.data = data;
        }

        public String getData() {
            if (!this.disposed) {
                return this.data;
            }
            throw new RuntimeException(this.data + " is already disposed");
        }

        public boolean tryDispose(long timeoutMillis) {
            this.disposed = true;
            return true;
        }
    }
}

