/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.tsdb2;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.avro.AvroCloseableIterable;
import org.spf4j.perf.TimeSeriesRecord;
import org.spf4j.tsdb2.TSDBQuery;
import org.spf4j.tsdb2.TSDBWriter;
import org.spf4j.tsdb2.avro.ColumnDef;
import org.spf4j.tsdb2.avro.TableDef;

public class TSDBQueryTest {
    private static final Logger LOG = LoggerFactory.getLogger(TSDBQueryTest.class);
    private final TableDef tableDef = TableDef.newBuilder().setName("test").setDescription("test-1").setSampleTime(0).setColumns(Arrays.asList(ColumnDef.newBuilder().setName("a").setDescription("atest").setUnitOfMeasurement("ms").build(), ColumnDef.newBuilder().setName("b").setDescription("btest").setUnitOfMeasurement("ms").build(), ColumnDef.newBuilder().setName("c x").setDescription("ctest x").setUnitOfMeasurement("ms").build())).build();

    @Test
    public void testTsDbQuery() throws IOException {
        File testFile = File.createTempFile("test", ".tsdb2");
        try (TSDBWriter writer = new TSDBWriter(testFile, 4, "test", false);){
            long tableId = writer.writeTableDef(this.tableDef);
            writer.writeDataRow(tableId, System.currentTimeMillis(), new long[]{0L, 1L, 2L});
            writer.writeDataRow(tableId, System.currentTimeMillis(), new long[]{1L, 1L, 2L});
            writer.writeDataRow(tableId, System.currentTimeMillis(), new long[]{2L, 1L, 2L});
            writer.writeDataRow(tableId, System.currentTimeMillis(), new long[]{3L, 1L, 2L});
            writer.writeDataRow(tableId, System.currentTimeMillis(), new long[]{4L, 1L, 2L});
            writer.flush();
            writer.writeDataRow(tableId, System.currentTimeMillis(), new long[]{0L, 1L, 2L});
            writer.writeDataRow(tableId, System.currentTimeMillis(), new long[]{1L, 1L, 2L});
            writer.writeDataRow(tableId, System.currentTimeMillis(), new long[]{2L, 1L, 2L});
            writer.writeDataRow(tableId, System.currentTimeMillis(), new long[]{3L, 1L, 2L});
            writer.writeDataRow(tableId, System.currentTimeMillis(), new long[]{4L, 1L, 2L});
        }
        var3_3 = null;
        try (AvroCloseableIterable res = TSDBQuery.getTimeSeriesData((File)testFile, (String)"test", (long)(System.currentTimeMillis() - 10000L), (long)System.currentTimeMillis());){
            int i = 0;
            for (TimeSeriesRecord rec : res) {
                LOG.debug("measurement", (Object)rec);
                ++i;
            }
            Assert.assertEquals((long)10L, (long)i);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }
}

