/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.tsdb2;

import com.google.common.collect.ListMultimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Either;
import org.spf4j.tsdb2.TSDBQuery;
import org.spf4j.tsdb2.TSDBReader;
import org.spf4j.tsdb2.TSDBWriter;
import org.spf4j.tsdb2.TimeSeries;
import org.spf4j.tsdb2.avro.ColumnDef;
import org.spf4j.tsdb2.avro.DataBlock;
import org.spf4j.tsdb2.avro.TableDef;

@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
public class TSDBReaderTest {
    private static final Logger LOG = LoggerFactory.getLogger(TSDBReaderTest.class);
    private final TableDef tableDef = TableDef.newBuilder().setName("test").setDescription("test").setSampleTime(0).setColumns(Arrays.asList(ColumnDef.newBuilder().setName("a").setDescription("atest").setUnitOfMeasurement("ms").build(), ColumnDef.newBuilder().setName("b").setDescription("btest").setUnitOfMeasurement("ms").build(), ColumnDef.newBuilder().setName("c").setDescription("ctest").setUnitOfMeasurement("ms").build())).build();

    @Test
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE", "NP_LOAD_OF_KNOWN_NULL_VALUE", "CLI_CONSTANT_LIST_INDEX"})
    public void testTsdb() throws IOException {
        long tableId;
        File testFile = File.createTempFile("test", ".tsdb2");
        TSDBWriter writer = new TSDBWriter(testFile, 4, "test", false);
        Throwable throwable = null;
        if (writer != null) {
            if (throwable != null) {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                writer.close();
            }
        }
        writer = new TSDBWriter(testFile, 4, "test", false);
        throwable = null;
        try {
            tableId = writer.writeTableDef(this.tableDef);
            long time = System.currentTimeMillis();
            writer.writeDataRow(tableId, time, new long[]{0L, 1L, 2L});
            writer.writeDataRow(tableId, time + 10L, new long[]{1L, 1L, 2L});
            writer.writeDataRow(tableId, time + 20L, new long[]{2L, 1L, 2L});
            writer.writeDataRow(tableId, time + 30L, new long[]{3L, 1L, 2L});
            writer.writeDataRow(tableId, time + 40L, new long[]{4L, 1L, 2L});
        }
        catch (Throwable time) {
            throwable = time;
            throw time;
        }
        finally {
            if (writer != null) {
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable time) {
                        throwable.addSuppressed(time);
                    }
                } else {
                    writer.close();
                }
            }
        }
        throwable = null;
        try (TSDBReader reader = new TSDBReader(testFile, 1024);){
            Either read;
            while ((read = reader.read()) != null) {
                LOG.debug("TSDB block: {}", (Object)read);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        ListMultimap allTables = TSDBQuery.getAllTables((File)testFile);
        Assert.assertEquals((long)1L, (long)allTables.size());
        Assert.assertTrue((boolean)allTables.containsKey((Object)this.tableDef.getName()));
        TimeSeries timeSeries = TSDBQuery.getTimeSeries((File)testFile, (long[])new long[]{tableId}, (long)0L, (long)Long.MAX_VALUE);
        Assert.assertEquals((long)2L, (long)timeSeries.getValues()[2][0]);
    }

    @Test(timeout=5000L)
    public void testTailing() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        File testFile = File.createTempFile("test", ".tsdb2");
        try (TSDBWriter writer = new TSDBWriter(testFile, 4, "test", true);
             TSDBReader reader = new TSDBReader(testFile, 1024);){
            writer.flush();
            ArrayBlockingQueue queue = new ArrayBlockingQueue(100);
            Future bgWatch = reader.bgWatch((object, deadline) -> queue.put(object), TSDBReader.EventSensitivity.HIGH);
            long tableId = writer.writeTableDef(this.tableDef);
            writer.flush();
            long time = System.currentTimeMillis();
            writer.writeDataRow(tableId, time, new long[]{0L, 1L, 2L});
            writer.writeDataRow(tableId, time + 10L, new long[]{1L, 1L, 2L});
            writer.flush();
            Either td = (Either)queue.take();
            Assert.assertEquals((Object)this.tableDef, (Object)td.getLeft());
            Either take = (Either)queue.take();
            Assert.assertEquals((long)2L, (long)((DataBlock)take.getRight()).getValues().size());
            writer.writeDataRow(tableId, time + 20L, new long[]{2L, 1L, 2L});
            writer.writeDataRow(tableId, time + 30L, new long[]{3L, 1L, 2L});
            writer.writeDataRow(tableId, time + 40L, new long[]{4L, 1L, 2L});
            writer.flush();
            Assert.assertEquals((long)3L, (long)((DataBlock)((Either)queue.take()).getRight()).getValues().size());
            reader.stopWatching();
            bgWatch.get(10000L, TimeUnit.MILLISECONDS);
        }
    }
}

