/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jdiff.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class Compress {
    private Compress() {
    }

    public static Path zip(Path fileOrFolderToCompress) throws IOException {
        Path parent = fileOrFolderToCompress.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Not a file: " + fileOrFolderToCompress);
        }
        Path destFile = parent.resolve(fileOrFolderToCompress.getFileName() + ".zip");
        Compress.zip(fileOrFolderToCompress, destFile);
        return destFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"AFBR_ABNORMAL_FINALLY_BLOCK_RETURN"})
    public static void zip(Path fileOrFolderToCompress, Path destFile) throws IOException {
        Path parent = destFile.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Parent is null for: " + fileOrFolderToCompress);
        }
        Path tmpFile = Files.createTempFile(parent, ".", "tmp", new FileAttribute[0]);
        try {
            Path relativePath = Files.isDirectory(fileOrFolderToCompress, new LinkOption[0]) ? fileOrFolderToCompress : fileOrFolderToCompress.getParent();
            try (BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(tmpFile, new OpenOption[0]));
                 ZipOutputStream zos = new ZipOutputStream((OutputStream)fos, StandardCharsets.UTF_8);
                 Stream<Path> stream = Files.walk(fileOrFolderToCompress, new FileVisitOption[0]);){
                stream.forEach(path -> {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        return;
                    }
                    String fileName = relativePath.relativize((Path)path).toString();
                    try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                        ZipEntry ze = new ZipEntry(fileName);
                        zos.putNextEntry(ze);
                        Compress.copy(in, zos);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException("Error compressing " + path, ex);
                    }
                });
            }
            Files.move(tmpFile, destFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tmpFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"AFBR_ABNORMAL_FINALLY_BLOCK_RETURN"})
    public static void copyFileAtomic(Path source, Path destinationFile) throws IOException {
        Path parent = destinationFile.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Destination " + destinationFile + " is not a file");
        }
        Path tmpFile = Files.createTempFile(parent, ".", null, new FileAttribute[0]);
        try {
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));
                 BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(tmpFile, new OpenOption[0]));){
                Compress.copy(in, os);
            }
            Files.move(tmpFile, destinationFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tmpFile);
        }
    }

    public static List<Path> unzip(Path zipFile) throws IOException {
        Path parent = zipFile.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("File " + zipFile + " cannot be unzipped to null parent folder");
        }
        return Compress.unzip(zipFile, parent);
    }

    public static List<Path> unzip(Path zipFile, Path destinationDirectory) throws IOException {
        if (!Files.exists(destinationDirectory, new LinkOption[0])) {
            Files.createDirectories(destinationDirectory, new FileAttribute[0]);
        }
        if (!Files.isDirectory(destinationDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("Destination " + destinationDirectory + " must be a directory");
        }
        final ArrayList<Path> response = new ArrayList<Path>();
        URI zipUri = URI.create("jar:" + zipFile.toUri().toURL());
        try (FileSystem zipFs = FileSystems.newFileSystem(zipUri, Collections.emptyMap());){
            for (final Path root : zipFs.getRootDirectories()) {
                final Path dest = destinationDirectory.resolve(root.toString().substring(1));
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path destination = dest.resolve(root.relativize(file).toString());
                        Compress.copyFileAtomic(file, destination);
                        response.add(destination);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        String dirStr = dir.toString();
                        Path np = dest.resolve(dirStr.substring(1));
                        Files.createDirectories(np, new FileAttribute[0]);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException | RuntimeException ex) {
            for (Path path : response) {
                try {
                    Files.delete(path);
                }
                catch (IOException | RuntimeException ex2) {
                    ex.addSuppressed(ex2);
                }
            }
            throw ex;
        }
        return response;
    }

    public static long copy(InputStream is, OutputStream os) throws IOException {
        return Compress.copy(is, os, 8192);
    }

    public static long copy(InputStream is, OutputStream os, int buffSize) throws IOException {
        if (buffSize < 2) {
            int val;
            long count = 0L;
            while ((val = is.read()) >= 0) {
                os.write(val);
                ++count;
            }
            return count;
        }
        long total = 0L;
        byte[] buffer = new byte[buffSize];
        boolean done = false;
        long bytesCopiedSinceLastFlush = 0L;
        while (true) {
            int nrRead;
            if (is.available() > 0) {
                nrRead = is.read(buffer, 0, buffSize);
                if (nrRead < 0) {
                    done = true;
                } else {
                    os.write(buffer, 0, nrRead);
                    total += (long)nrRead;
                    bytesCopiedSinceLastFlush += (long)nrRead;
                    continue;
                }
            }
            if (bytesCopiedSinceLastFlush > 0L) {
                os.flush();
                bytesCopiedSinceLastFlush = 0L;
            }
            if (done || (nrRead = is.read(buffer, 0, buffSize)) < 0) break;
            os.write(buffer, 0, nrRead);
            total += (long)nrRead;
            bytesCopiedSinceLastFlush += (long)nrRead;
        }
        return total;
    }
}

