/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jdiff;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.RemoteRepository;

@SuppressFBWarnings(value={"AI_ANNOTATION_ISSUES_NEEDS_NULLABLE"})
public abstract class BaseJDiffMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/jdiff", readonly=true)
    private File workingDirectory;
    @Parameter(property="javadocExecutable")
    private String javadocExecutable;
    @Parameter(property="includePackageNames")
    private ArrayList<String> includePackageNames = new ArrayList(2);
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    private MojoExecution mojoExecution;
    @Component
    private RepositorySystem repoSystem;

    final MavenSession getMavenSession() {
        return this.mavenSession;
    }

    final String getJavadocExecutable() throws IOException {
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in jdiff-maven-plugin: " + tc));
            if (this.javadocExecutable != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'javadocExecutable' parameter is set to " + this.javadocExecutable));
            } else {
                this.javadocExecutable = tc.findTool("javadoc");
            }
        }
        String javadocCommand = "javadoc" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        if (StringUtils.isNotEmpty((String)this.javadocExecutable)) {
            File javadocExe = new File(this.javadocExecutable);
            if (javadocExe.isDirectory()) {
                javadocExe = new File(javadocExe, javadocCommand);
            }
            if (SystemUtils.IS_OS_WINDOWS && javadocExe.getName().indexOf(46) < 0) {
                javadocExe = new File(javadocExe.getPath() + ".exe");
            }
            if (!javadocExe.isFile()) {
                throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. Verify the <javadocExecutable/> parameter.");
            }
            return javadocExe.getAbsolutePath();
        }
        File javaHome = SystemUtils.getJavaHome();
        File javadocExe = SystemUtils.IS_OS_AIX ? new File(javaHome + File.separator + ".." + File.separator + "sh", javadocCommand) : (SystemUtils.IS_OS_MAC_OSX ? new File(javaHome + File.separator + "bin", javadocCommand) : new File(javaHome + File.separator + ".." + File.separator + "bin", javadocCommand));
        if (!javadocExe.exists() || !javadocExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            String javaHomeStr = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHomeStr)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set: javahome='" + javaHomeStr + '\'');
            }
            File javaHomeFile = new File(javaHomeStr);
            if (!javaHomeFile.exists() || !javaHomeFile.isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javadocExe = new File(javaHomeStr + File.separator + "bin", javadocCommand);
        }
        if (!javadocExe.exists() || !javadocExe.isFile()) {
            throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javadocExe.getAbsolutePath();
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.toolchainManager != null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.mavenSession);
        }
        return tc;
    }

    final List<String> getCompileSourceRoots() {
        if ("pom".equalsIgnoreCase(this.mavenProject.getPackaging())) {
            return Collections.emptyList();
        }
        List compileSourceRoots = this.mavenProject.getCompileSourceRoots();
        return compileSourceRoots == null ? Collections.EMPTY_LIST : compileSourceRoots;
    }

    final MavenProject getMavenProject() {
        return this.mavenProject;
    }

    final File getWorkingDirectory() {
        return this.workingDirectory;
    }

    final MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    final List<RemoteRepository> getProjectRepos() {
        return this.mavenProject.getRemoteProjectRepositories();
    }

    final RepositorySystem getRepoSystem() {
        return this.repoSystem;
    }

    final ArrayList<String> getIncludePackageNames() {
        return this.includePackageNames;
    }

    final ToolchainManager getToolchainManager() {
        return this.toolchainManager;
    }

    public String toString() {
        return "BaseJDiffMojo{workingDirectory=" + this.workingDirectory + ", javadocExecutable=" + this.javadocExecutable + ", includePackageNames=" + this.includePackageNames + '}';
    }
}

