/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jdiff;

import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.version.Version;
import org.spf4j.io.compress.Compress;
import org.spf4j.jdiff.JDiffUtils;
import org.spf4j.jdiff.JavadocExecutionException;
import org.spf4j.jdiff.JavadocExecutor;
import org.spf4j.maven.MavenRepositoryUtils;

@SuppressFBWarnings(value={"AFBR_ABNORMAL_FINALLY_BLOCK_RETURN"})
public final class JDiffRunner {
    private final String docletPath;
    private final String javadocExec;
    private final List<RemoteRepository> remoteRepos;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession reposSession;

    public JDiffRunner() {
        this(null, null, null, Collections.singletonList(MavenRepositoryUtils.getDefaultRepository()), MavenRepositoryUtils.getRepositorySystem(), System.getProperty("spf4j.jdiff.javadocExec"));
    }

    @SuppressFBWarnings(value={"STT_TOSTRING_STORED_IN_FIELD"})
    public JDiffRunner(MojoExecution mojoExec, ToolchainManager toolchainManager, MavenSession session, List<RemoteRepository> remoteRepos, RepositorySystem repositorySystem, String javadocExec) {
        String home;
        this.remoteRepos = remoteRepos;
        this.repositorySystem = repositorySystem;
        this.reposSession = session != null ? session.getRepositorySession() : MavenRepositoryUtils.getRepositorySystemSession((RepositorySystem)MavenRepositoryUtils.getRepositorySystem(), (File)new File(System.getProperty("user.home"), ".m2/repository"));
        if (mojoExec != null) {
            StringBuilder cp = new StringBuilder(32);
            Map artifactMap = mojoExec.getMojoDescriptor().getPluginDescriptor().getArtifactMap();
            cp.append(((Artifact)artifactMap.get("jdiff:jdiff")).getFile().getAbsolutePath());
            cp.append(File.pathSeparatorChar);
            cp.append(((Artifact)artifactMap.get("xerces:xercesImpl")).getFile().getAbsolutePath());
            cp.append(File.pathSeparatorChar);
            this.docletPath = cp.toString();
        } else {
            try {
                Set artf1 = MavenRepositoryUtils.resolveArtifactAndDependencies((String)"runtime", (String)"jdiff", (String)"jdiff", null, (String)"jar", (String)"1.0.9", remoteRepos, (RepositorySystem)repositorySystem, (RepositorySystemSession)this.reposSession);
                Set artf2 = MavenRepositoryUtils.resolveArtifactAndDependencies((String)"runtime", (String)"xerces", (String)"xercesImpl", null, (String)"jar", (String)"2.10.0", remoteRepos, (RepositorySystem)repositorySystem, (RepositorySystemSession)this.reposSession);
                artf1.addAll(artf2);
                this.docletPath = MavenRepositoryUtils.toPath((Collection)artf1);
            }
            catch (DependencyResolutionException ex) {
                throw new UncheckedExecutionException((Throwable)ex);
            }
        }
        this.javadocExec = javadocExec == null ? (toolchainManager == null ? ((home = System.getProperty("java.home")).contains("jre") ? home + "/../bin/javadoc" : home + "/bin/javadoc") : toolchainManager.getToolchainFromBuildContext("jdk", session).findTool("javadoc")) : javadocExec;
    }

    public Set<String> generateJDiffXML(Collection<File> sources, Collection<File> classPath, File destinationFolder, String apiName, Collection<String> includePackageNames) throws JavadocExecutionException, IOException {
        try {
            Files.createDirectories(destinationFolder.toPath(), new FileAttribute[0]);
            JavadocExecutor javadoc = new JavadocExecutor(this.javadocExec);
            javadoc.addArgumentPair("doclet", "jdiff.JDiff");
            javadoc.addArgumentPair("docletpath", this.docletPath);
            javadoc.addArgumentPair("apiname", apiName);
            javadoc.addArgumentPair("apidir", destinationFolder.getAbsolutePath());
            javadoc.addArgumentPair("classpath", MavenRepositoryUtils.toPath(classPath));
            javadoc.addArgumentPair("sourcepath", MavenRepositoryUtils.toPath(sources));
            Set<Object> pckgs = new TreeSet();
            if (includePackageNames != null && !includePackageNames.isEmpty()) {
                pckgs.addAll(includePackageNames);
            } else {
                pckgs = JDiffUtils.getPackages(sources);
            }
            for (String string : pckgs) {
                javadoc.addArgument(string);
            }
            javadoc.execute(destinationFolder);
            return pckgs;
        }
        catch (IOException e) {
            throw new JavadocExecutionException(e.getMessage(), e);
        }
    }

    public void generateReport(File srcDir, String oldApi, String newApi, String javadocOld, String javadocNew, Set<String> packages, File destinationDir) throws JavadocExecutionException, IOException {
        Files.createDirectories(destinationDir.toPath(), new FileAttribute[0]);
        JavadocExecutor javadoc = new JavadocExecutor(this.javadocExec);
        javadoc.addArgument("-private");
        javadoc.addArgumentPair("d", destinationDir.getAbsolutePath());
        String absolutePath = srcDir.getAbsolutePath();
        javadoc.addArgumentPair("oldapidir", absolutePath);
        javadoc.addArgumentPair("newapidir", absolutePath);
        if (javadocOld != null) {
            javadoc.addArgumentPair("javadocold", javadocOld);
        }
        if (javadocNew != null) {
            javadoc.addArgumentPair("javadocnew", javadocNew);
        }
        javadoc.addArgumentPair("doclet", "jdiff.JDiff");
        javadoc.addArgumentPair("docletpath", this.docletPath);
        javadoc.addArgumentPair("oldapi", oldApi);
        javadoc.addArgumentPair("newapi", newApi);
        javadoc.addArgument("-stats");
        for (String pckg : packages) {
            javadoc.addArgument(pckg);
        }
        javadoc.execute(destinationDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDiffBetweenReleases(String groupId, String artifactId, String versionRange, File destinationFolder, int maxNrOFDiffs) throws DependencyResolutionException, VersionRangeResolutionException, IOException, ArtifactResolutionException, JavadocExecutionException {
        JDiffRunner jdiff = new JDiffRunner();
        List rangeVersions = MavenRepositoryUtils.getVersions((String)groupId, (String)artifactId, (String)versionRange, this.remoteRepos, (RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.reposSession);
        int size = rangeVersions.size();
        if (size < 2) {
            return;
        }
        LinkedList versions = new LinkedList();
        versions.add(rangeVersions.get(size - 1));
        int j = 1;
        for (int i = size - 2; i >= 0 && j < maxNrOFDiffs; --i) {
            Version ver = (Version)rangeVersions.get(i);
            if (ver.toString().contains("SNAPSHOT")) continue;
            versions.addFirst(ver);
            ++j;
        }
        Version v = (Version)versions.get(0);
        File prevSourcesArtifact = MavenRepositoryUtils.resolveArtifact((String)groupId, (String)artifactId, (String)"sources", (String)"jar", (String)v.toString(), this.remoteRepos, (RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.reposSession);
        File prevJavaDocArtifact = MavenRepositoryUtils.resolveArtifact((String)groupId, (String)artifactId, (String)"javadoc", (String)"jar", (String)v.toString(), this.remoteRepos, (RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.reposSession);
        Path tempDir = Files.createTempDirectory("jdiff", new FileAttribute[0]);
        try {
            Path sourceDestination = tempDir.resolve(artifactId).resolve(v.toString()).resolve("sources");
            Compress.unzip((Path)prevSourcesArtifact.toPath(), (Path)sourceDestination);
            Set deps = MavenRepositoryUtils.resolveArtifactAndDependencies((String)"compile", (String)groupId, (String)artifactId, null, (String)"jar", (String)v.toString(), this.remoteRepos, (RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.reposSession);
            String prevApiName = artifactId + '-' + v;
            Set<String> prevPackages = jdiff.generateJDiffXML(Collections.singletonList(sourceDestination.toFile()), deps, destinationFolder, prevApiName, null);
            int l = versions.size();
            for (int i = 1; i < l; ++i) {
                v = (Version)versions.get(i);
                File sourceArtifact = MavenRepositoryUtils.resolveArtifact((String)groupId, (String)artifactId, (String)"sources", (String)"jar", (String)v.toString(), this.remoteRepos, (RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.reposSession);
                File javadocArtifact = MavenRepositoryUtils.resolveArtifact((String)groupId, (String)artifactId, (String)"javadoc", (String)"jar", (String)v.toString(), this.remoteRepos, (RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.reposSession);
                sourceDestination = tempDir.resolve(artifactId).resolve(v.toString()).resolve("sources");
                Compress.unzip((Path)sourceArtifact.toPath(), (Path)sourceDestination);
                deps = MavenRepositoryUtils.resolveArtifactAndDependencies((String)"compile", (String)groupId, (String)artifactId, null, (String)"jar", (String)v.toString(), this.remoteRepos, (RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.reposSession);
                String apiName = artifactId + '-' + v;
                Set<String> packages = jdiff.generateJDiffXML(Collections.singletonList(sourceDestination.toFile()), deps, destinationFolder, apiName, null);
                prevPackages.addAll(packages);
                Path reportsDestination = destinationFolder.toPath().resolve(prevApiName + '_' + apiName);
                Compress.unzip((Path)prevJavaDocArtifact.toPath(), (Path)reportsDestination.resolve(prevApiName));
                Compress.unzip((Path)javadocArtifact.toPath(), (Path)reportsDestination.resolve(apiName));
                jdiff.generateReport(destinationFolder, prevApiName, apiName, "../" + prevApiName + '/', "../" + apiName + '/', prevPackages, reportsDestination.toFile());
                prevApiName = apiName;
                prevPackages = packages;
                prevJavaDocArtifact = javadocArtifact;
            }
        }
        finally {
            FileUtils.deleteDirectory((File)tempDir.toFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDiffBetweenReleases(String groupId, String artifactId, String version1, String version2, File destinationFolder, Set<String> includePackages) throws ArtifactResolutionException, DependencyResolutionException, IOException, JavadocExecutionException {
        JDiffRunner jdiff = new JDiffRunner();
        File prevSourcesArtifact = MavenRepositoryUtils.resolveArtifact((String)groupId, (String)artifactId, (String)"sources", (String)"jar", (String)version1, this.remoteRepos, (RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.reposSession);
        File prevJavaDocArtifact = MavenRepositoryUtils.resolveArtifact((String)groupId, (String)artifactId, (String)"javadoc", (String)"jar", (String)version1, this.remoteRepos, (RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.reposSession);
        Path tempDir = Files.createTempDirectory("jdiff", new FileAttribute[0]);
        try {
            Path sourceDestination = tempDir.resolve(artifactId).resolve(version1).resolve("sources");
            Compress.unzip((Path)prevSourcesArtifact.toPath(), (Path)sourceDestination);
            Set deps = MavenRepositoryUtils.resolveArtifactAndDependencies((String)"compile", (String)groupId, (String)artifactId, null, (String)"jar", (String)version1, this.remoteRepos, (RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.reposSession);
            String prevApiName = artifactId + '-' + version1;
            Set<String> prevPackages = jdiff.generateJDiffXML(Collections.singletonList(sourceDestination.toFile()), deps, destinationFolder, prevApiName, includePackages);
            File sourceArtifact = MavenRepositoryUtils.resolveArtifact((String)groupId, (String)artifactId, (String)"sources", (String)"jar", (String)version2, this.remoteRepos, (RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.reposSession);
            File javadocArtifact = MavenRepositoryUtils.resolveArtifact((String)groupId, (String)artifactId, (String)"javadoc", (String)"jar", (String)version2, this.remoteRepos, (RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.reposSession);
            sourceDestination = tempDir.resolve(artifactId).resolve(version2).resolve("sources");
            Compress.unzip((Path)sourceArtifact.toPath(), (Path)sourceDestination);
            deps = MavenRepositoryUtils.resolveArtifactAndDependencies((String)"compile", (String)groupId, (String)artifactId, null, (String)"jar", (String)version2, this.remoteRepos, (RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.reposSession);
            String apiName = artifactId + '-' + version2;
            Set<String> packages = jdiff.generateJDiffXML(Collections.singletonList(sourceDestination.toFile()), deps, destinationFolder, apiName, includePackages);
            prevPackages.addAll(packages);
            Compress.unzip((Path)prevJavaDocArtifact.toPath(), (Path)destinationFolder.toPath().resolve(prevApiName));
            Compress.unzip((Path)javadocArtifact.toPath(), (Path)destinationFolder.toPath().resolve(apiName));
            jdiff.generateReport(destinationFolder, prevApiName, apiName, "../" + prevApiName + '/', "../" + apiName + '/', prevPackages, destinationFolder);
        }
        finally {
            FileUtils.deleteDirectory((File)tempDir.toFile());
        }
    }

    public void writeChangesIndexHtml(File reportOutputDirectory, String fileName) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(reportOutputDirectory.toPath().resolve(fileName), new OpenOption[0]), StandardCharsets.UTF_8));){
            writer.append("<HTML>\n<HEAD>\n<TITLE>\nAPI Differences Reports\n</TITLE>\n</HEAD>\n<BODY>\n<table summary=\"Api Difference Reports\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
            Path reportPath = reportOutputDirectory.toPath();
            try (Stream<Path> stream = Files.walk(reportPath, 2, new FileVisitOption[0]);){
                stream.map(p -> reportPath.relativize((Path)p)).filter(p -> p.getNameCount() > 1 && p.endsWith("changes.html")).forEach(p -> {
                    try {
                        writer.append("  <tr>\n  <td bgcolor=\"#FFFFCC\">\n    <font size=\"+1\"><a href=\"" + p + "\"> " + p.getName(0).toString().replace("_", " to ") + " </a></font>\n  </td>\n  </tr>");
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                });
            }
            writer.append("</TABLE>\n</BODY>\n</HTML>");
        }
    }

    public String toString() {
        return "JDiffRunner{docletPath=" + this.docletPath + ", javadocExec=" + this.javadocExec + ", remoteRepos=" + this.remoteRepos + ", repositorySystem=" + this.repositorySystem + ", reposSession=" + this.reposSession + '}';
    }
}

