/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jdiff;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;
import org.spf4j.jdiff.JDiffRunner;
import org.spf4j.jdiff.JavadocExecutionException;

public final class ApiDiffCmd {
    private ApiDiffCmd() {
    }

    public static void main(String[] args) throws DependencyResolutionException, VersionRangeResolutionException, IOException, ArtifactResolutionException, JavadocExecutionException {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println("Error: " + e.getMessage() + "\nUsage:");
            parser.printUsage((OutputStream)System.err);
            System.exit(64);
        }
        JDiffRunner runner = new JDiffRunner();
        runner.runDiffBetweenReleases(options.groupId, options.artifactId, options.fromVersion, options.toVersion, options.destination, (Set<String>)ImmutableSet.copyOf((Object[])options.packages));
        System.exit(0);
    }

    private static class Options {
        @Option(name="-gId", usage="maven artifact group id", required=true)
        private String groupId = "";
        @Option(name="-aId", usage="maven artifact id", required=true)
        private String artifactId = "";
        @Option(name="-fromVersion", usage="from version", required=true)
        private String fromVersion = "";
        @Option(name="-toVersion", usage="to version", required=true)
        private String toVersion = "";
        @Option(name="-o", usage="destination folder")
        private File destination = new File(".");
        @Option(name="-p", usage="packages list", handler=StringArrayOptionHandler.class)
        private String[] packages = new String[0];

        private Options() {
        }
    }
}

