/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Marker;
import org.spf4j.base.Arrays;
import org.spf4j.base.PackageInfo;
import org.spf4j.base.Slf4jMessageFormatter;
import org.spf4j.base.StackSamples;
import org.spf4j.base.avro.FileLocation;
import org.spf4j.base.avro.LogLevel;
import org.spf4j.base.avro.LogRecord;
import org.spf4j.base.avro.Method;
import org.spf4j.base.avro.RemoteException;
import org.spf4j.base.avro.Throwable;
import org.spf4j.ds.IdentityHashSet;
import org.spf4j.log.Level;
import org.spf4j.log.LogAttribute;
import org.spf4j.log.Slf4jLogRecord;
import org.spf4j.log.Slf4jLogRecordImpl;
import org.spf4j.log.ThrowableProxy;

@ParametersAreNonnullByDefault
public final class Converters {
    private Converters() {
    }

    public static org.spf4j.base.avro.StackTraceElement convert(StackTraceElementProxy stackTrace) {
        StackTraceElement stackTraceElement = stackTrace.getStackTraceElement();
        String className = stackTraceElement.getClassName();
        String fileName = stackTraceElement.getFileName();
        return new org.spf4j.base.avro.StackTraceElement(new Method(className, stackTraceElement.getMethodName()), fileName == null ? null : new FileLocation(fileName, stackTraceElement.getLineNumber(), -1), PackageInfo.getPackageInfo((String)className));
    }

    public static List<org.spf4j.base.avro.StackTraceElement> convert(StackTraceElementProxy[] stackTraces) {
        int l = stackTraces.length;
        if (l == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<org.spf4j.base.avro.StackTraceElement> result = new ArrayList<org.spf4j.base.avro.StackTraceElement>(l);
        for (StackTraceElementProxy st : stackTraces) {
            result.add(Converters.convert(st));
        }
        return result;
    }

    public static List<Throwable> convert(IThrowableProxy[] throwables, Set<IThrowableProxy> seen) {
        int l = throwables.length;
        if (l == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Throwable> result = new ArrayList<Throwable>(l);
        for (IThrowableProxy t : throwables) {
            result.add(Converters.convert(t, seen));
        }
        return result;
    }

    public static Throwable convert(IThrowableProxy throwable) {
        return Converters.convert(throwable, (Set<IThrowableProxy>)new IdentityHashSet(8));
    }

    @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
    public static Throwable convert(IThrowableProxy throwable, Set<IThrowableProxy> seen) {
        java.lang.Throwable jThr;
        if (seen.contains(throwable)) {
            return new Throwable(throwable.getClassName(), "CIRCULAR REFERENCE: " + throwable.getMessage(), Collections.EMPTY_LIST, null, Collections.EMPTY_LIST);
        }
        seen.add(throwable);
        String message = throwable.getMessage();
        RemoteException rex = null;
        if (throwable instanceof ThrowableProxy) {
            jThr = ((ThrowableProxy)throwable).getThrowable();
            if (jThr instanceof RemoteException) {
                rex = (RemoteException)jThr;
            }
        } else if (throwable instanceof ch.qos.logback.classic.spi.ThrowableProxy && (jThr = ((ch.qos.logback.classic.spi.ThrowableProxy)throwable).getThrowable()) instanceof RemoteException) {
            rex = (RemoteException)jThr;
        }
        if (rex != null) {
            return new Throwable(throwable.getClassName(), message == null ? "" : message, Converters.convert(throwable.getStackTraceElementProxyArray()), rex.getRemoteCause(), Converters.convert(throwable.getSuppressed(), seen));
        }
        IThrowableProxy cause = throwable.getCause();
        return new Throwable(throwable.getClassName(), message == null ? "" : message, Converters.convert(throwable.getStackTraceElementProxyArray()), cause == null ? null : Converters.convert(cause, seen), Converters.convert(throwable.getSuppressed(), seen));
    }

    @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
    public static java.lang.Throwable convert2(IThrowableProxy throwable) {
        if (throwable instanceof ThrowableProxy) {
            return ((ThrowableProxy)throwable).getThrowable();
        }
        if (throwable instanceof ch.qos.logback.classic.spi.ThrowableProxy) {
            return ((ch.qos.logback.classic.spi.ThrowableProxy)throwable).getThrowable();
        }
        throw new UnsupportedOperationException("Cannot convert " + throwable);
    }

    public static LogLevel convert(ch.qos.logback.classic.Level level) {
        if (level.levelInt >= 40000) {
            return LogLevel.ERROR;
        }
        if (level.levelInt >= 30000) {
            return LogLevel.WARN;
        }
        if (level.levelInt >= 20000) {
            return LogLevel.INFO;
        }
        if (level.levelInt >= 10000) {
            return LogLevel.DEBUG;
        }
        return LogLevel.TRACE;
    }

    public static Level convert2(ch.qos.logback.classic.Level level) {
        if (level.levelInt >= 40000) {
            return Level.ERROR;
        }
        if (level.levelInt >= 30000) {
            return Level.WARN;
        }
        if (level.levelInt >= 20000) {
            return Level.INFO;
        }
        if (level.levelInt >= 10000) {
            return Level.DEBUG;
        }
        return Level.TRACE;
    }

    @SuppressFBWarnings(value={"WOC_WRITE_ONLY_COLLECTION_LOCAL", "ITC_INHERITANCE_TYPE_CHECKING"})
    public static LogRecord convert(ILoggingEvent event) {
        List<Object> xArgs;
        int index;
        IThrowableProxy extraThrowable = event.getThrowableProxy();
        Marker marker = event.getMarker();
        Object[] arguments = event.getArgumentArray();
        if (arguments == null) {
            arguments = Arrays.EMPTY_OBJ_ARRAY;
        }
        String fmt = event.getMessage();
        StringBuilder msgBuilder = new StringBuilder(fmt.length() + 8);
        try {
            index = Slf4jMessageFormatter.format((Appendable)msgBuilder, (String)fmt, (Object[])arguments);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        String traceId = "";
        List profiles = Collections.EMPTY_LIST;
        HashMap attribs = null;
        if (index >= arguments.length) {
            xArgs = Collections.EMPTY_LIST;
        } else {
            Object obj;
            int i;
            int nrXArgs = 0;
            int nrAttribs = 0;
            for (i = index; i < arguments.length; ++i) {
                obj = arguments[i];
                if (obj instanceof LogAttribute) {
                    String attrName;
                    LogAttribute la = (LogAttribute)obj;
                    switch (attrName = la.getName()) {
                        case "trId": {
                            traceId = la.getValue().toString();
                            break;
                        }
                        case "prSamples": {
                            profiles = org.spf4j.base.avro.Converters.convert((StackSamples)((StackSamples)la.getValue()));
                            break;
                        }
                        default: {
                            ++nrAttribs;
                            break;
                        }
                    }
                    continue;
                }
                if (obj instanceof java.lang.Throwable) {
                    if (extraThrowable == null) {
                        extraThrowable = ThrowableProxy.create((java.lang.Throwable)obj);
                        continue;
                    }
                    extraThrowable = ThrowableProxy.addSuppressed(extraThrowable, ThrowableProxy.create((java.lang.Throwable)obj));
                    continue;
                }
                ++nrXArgs;
            }
            xArgs = nrXArgs == 0 ? Collections.EMPTY_LIST : new ArrayList<Object>(nrXArgs);
            attribs = Maps.newHashMapWithExpectedSize((int)(nrAttribs + (marker == null ? 0 : 1)));
            for (i = index; i < arguments.length; ++i) {
                obj = arguments[i];
                if (obj instanceof LogAttribute) {
                    String name = ((LogAttribute)obj).getName();
                    if ("trId".equals(name) || "prSamples".equals(name)) continue;
                    attribs.put(name, ((LogAttribute)obj).getValue());
                    continue;
                }
                if (obj instanceof java.lang.Throwable) continue;
                xArgs.add(obj);
            }
            if (marker != null) {
                attribs.put(marker.getName(), marker);
            }
        }
        return new LogRecord("", traceId, Converters.convert(event.getLevel()), Instant.ofEpochMilli(event.getTimeStamp()), event.getLoggerName(), event.getThreadName(), msgBuilder.toString(), xArgs, attribs == null ? Collections.EMPTY_MAP : attribs, extraThrowable == null ? null : Converters.convert(extraThrowable), profiles);
    }

    @SuppressFBWarnings(value={"WOC_WRITE_ONLY_COLLECTION_LOCAL"})
    public static Slf4jLogRecord convert2(ILoggingEvent event) {
        IThrowableProxy extraThrowable = event.getThrowableProxy();
        Object[] arguments = extraThrowable == null ? event.getArgumentArray() : Arrays.append((Object[])event.getArgumentArray(), (Object)Converters.convert2(extraThrowable));
        return new Slf4jLogRecordImpl(false, event.getLoggerName(), Converters.convert2(event.getLevel()), event.getMarker(), event.getTimeStamp(), event.getMessage(), arguments);
    }
}

