/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.FileReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Runtime;
import org.spf4j.base.avro.LogRecord;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.log.Converters;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
public final class AvroDataFileAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final ZoneId ZULU = ZoneId.of("Z");
    private final Object sync = new Object();
    private String fileNameBase;
    private DataFileWriter<LogRecord> writer;
    private LocalDate fileDate;
    private Path currentFile;
    private Path destinationPath;
    private ZoneId zoneId = ZULU;
    private CodecFactory codecFact;
    private int maxNrFiles;
    private long maxLogsBytes;
    private CompletableFuture<Void> cleanup;

    public AvroDataFileAppender() {
        this.fileNameBase = Runtime.PROCESS_NAME;
        this.setName("avroLogAppender");
        try {
            Class.forName("org.xerial.snappy.Snappy");
            this.codecFact = CodecFactory.snappyCodec();
        }
        catch (ClassNotFoundException ex) {
            this.codecFact = null;
        }
        this.maxNrFiles = 15;
        this.maxLogsBytes = 0x6400000L;
        this.cleanup = CompletableFuture.completedFuture(null);
    }

    public void setMaxNrFiles(int maxNrFiles) {
        if (maxNrFiles < 2) {
            throw new IllegalArgumentException("At least 2 files must be configured:" + maxNrFiles);
        }
        this.maxNrFiles = maxNrFiles;
    }

    public void setMaxLogsBytes(long maxLogsBytes) {
        if (maxLogsBytes < 10240L) {
            throw new IllegalArgumentException("max size too small " + maxLogsBytes);
        }
        this.maxLogsBytes = maxLogsBytes;
    }

    public void setCodec(String codec) {
        if (codec == null) {
            this.codecFact = null;
            return;
        }
        switch (codec) {
            case "snappy": {
                this.codecFact = CodecFactory.snappyCodec();
                return;
            }
            case "bzip2": {
                this.codecFact = CodecFactory.bzip2Codec();
                return;
            }
            case "deflate": {
                this.codecFact = CodecFactory.deflateCodec((int)1);
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported codec: " + codec);
    }

    public void setFileNameBase(String fileNameBase) {
        this.fileNameBase = fileNameBase;
    }

    public void setDestinationPath(String destinationPath) {
        this.destinationPath = Paths.get(destinationPath, new String[0]);
    }

    public void setPartitionZoneID(String zoneIdStr) {
        this.zoneId = ZoneId.of(zoneIdStr);
    }

    @JmxExport
    public Path getDestinationPath() {
        return this.destinationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxExport
    public void cleanup() throws IOException {
        Class<AvroDataFileAppender> clazz = AvroDataFileAppender.class;
        synchronized (AvroDataFileAppender.class) {
            Path path2;
            Iterator<Path> iterator;
            List<Path> logFiles = this.getLogFiles();
            if (logFiles.size() > this.maxNrFiles) {
                int toDelete = logFiles.size() - this.maxNrFiles;
                int i = 0;
                iterator = logFiles.iterator();
                while (iterator.hasNext()) {
                    path2 = iterator.next();
                    if (i >= toDelete) break;
                    Logger.getLogger(AvroDataFileAppender.class.getName()).log(Level.INFO, "Deleting {0}", path2);
                    Files.delete(path2);
                    iterator.remove();
                    ++i;
                }
            }
            long size = 0L;
            for (Path path2 : logFiles) {
                size += path2.toFile().length();
            }
            iterator = logFiles.iterator();
            while (size > this.maxLogsBytes && iterator.hasNext()) {
                path2 = iterator.next();
                if (!iterator.hasNext()) continue;
                size -= path2.toFile().length();
                Logger.getLogger(AvroDataFileAppender.class.getName()).log(Level.INFO, "Deleting {0}", path2);
                Files.delete(path2);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @JmxExport
    public List<Path> getLogFiles() throws IOException {
        ArrayList<Path> contents = new ArrayList<Path>();
        try (DirectoryStream<Path> dStream = Files.newDirectoryStream(this.destinationPath, path -> {
            Path fileName = path.getFileName();
            if (fileName == null) {
                return false;
            }
            String name = fileName.toString();
            return name.startsWith(this.fileNameBase) && name.endsWith(".logs.avro");
        });){
            for (Path p : dStream) {
                contents.add(p);
            }
        }
        Collections.sort(contents, FileChronoComparator.INSTANCE);
        return contents;
    }

    public List<Path> getOldLogFiles() throws IOException {
        List<Path> logFiles = this.getLogFiles();
        int idx = 0;
        for (Path p : logFiles) {
            if (p.equals(this.currentFile)) break;
            ++idx;
        }
        return logFiles.subList(0, idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxExport
    public Path getCurrentFile() {
        Object object = this.sync;
        synchronized (object) {
            return this.currentFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxExport
    public long flush() throws IOException {
        Object object = this.sync;
        synchronized (object) {
            if (this.isStarted()) {
                long location = this.writer.sync();
                this.writer.fSync();
                return location;
            }
            return -1L;
        }
    }

    @JmxExport
    public long getNrLogs() throws IOException {
        return AvroDataFileAppender.getNrLogs(this.getCurrentFile());
    }

    public FileReader<LogRecord> getCurrentLogs() throws IOException {
        if (this.isStarted()) {
            this.flush();
        }
        return DataFileReader.openReader((File)this.getCurrentFile().toFile(), (DatumReader)new SpecificDatumReader(LogRecord.class));
    }

    public void getLogs(String originPrefix, long ptailOffset, int limit, Consumer<LogRecord> records) throws IOException {
        this.getLogs(this.getLogFiles(), originPrefix, ptailOffset, limit, records);
    }

    private void getLogs(List<Path> logFiles, String originPrefix, long ptailOffset, int limit, Consumer<LogRecord> records) throws IOException {
        List result = Collections.EMPTY_LIST;
        if (logFiles.isEmpty()) {
            return;
        }
        if (this.isStarted()) {
            this.flush();
        }
        long tailOffset = ptailOffset;
        SpecificDatumReader reader = new SpecificDatumReader(LogRecord.class);
        for (int i = logFiles.size() - 1; i >= 0 && result.size() < limit; --i) {
            Path p = logFiles.get(i);
            long nrRecs = AvroDataFileAppender.getNrLogs(p);
            tailOffset = (nrRecs -= tailOffset) <= 0L ? -nrRecs : 0L;
            int left = limit - result.size();
            long toSkip = nrRecs - (long)left;
            try (DataFileStream stream = new DataFileStream(Files.newInputStream(p, new OpenOption[0]), (DatumReader)reader);){
                if (toSkip > 0L) {
                    AvroDataFileAppender.skip((DataFileStream<LogRecord>)stream, toSkip);
                } else {
                    toSkip = 0L;
                }
                for (int j = 0; nrRecs > 0L && j < left; --nrRecs, ++j) {
                    LogRecord log = (LogRecord)stream.next();
                    if (originPrefix != null) {
                        log.setOrigin(originPrefix + ':' + p + ':' + toSkip++);
                    }
                    records.accept(log);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFilteredLogs(String originPrefix, long ptailOffset, int limit, Predicate<LogRecord> pred, Consumer<LogRecord> records) throws IOException {
        List<Path> logFiles = this.getLogFiles();
        if (logFiles.isEmpty()) {
            return;
        }
        if (this.isStarted()) {
            this.flush();
        }
        File tmp = this.writeResultSet(logFiles, originPrefix, pred);
        try {
            this.getLogs(Collections.singletonList(tmp.toPath()), null, ptailOffset, limit, records);
        }
        finally {
            if (!tmp.delete()) {
                this.addError("Unable to delete temp file " + tmp);
            }
        }
    }

    private File writeResultSet(List<Path> logFiles, String originPrefix, Predicate<LogRecord> pred) throws IOException {
        File tmp = File.createTempFile("scan", "tmp.avro", this.destinationPath.toFile());
        try (DataFileWriter wr = new DataFileWriter((DatumWriter)new SpecificDatumWriter(LogRecord.class));){
            if (this.codecFact != null) {
                wr.setCodec(this.codecFact);
            }
            wr.create(LogRecord.getClassSchema(), tmp);
            for (Path p : logFiles) {
                FileReader reader = DataFileReader.openReader((File)p.toFile(), (DatumReader)new SpecificDatumReader(LogRecord.class));
                int loc = 0;
                while (reader.hasNext()) {
                    LogRecord log = (LogRecord)reader.next();
                    log.setOrigin(originPrefix + ':' + p + ':' + loc++);
                    if (!pred.test(log)) continue;
                    wr.append((Object)log);
                }
            }
        }
        catch (IOException | RuntimeException ex) {
            if (!tmp.delete()) {
                IOException ioEx = new IOException("Cannot delete " + tmp);
                ioEx.addSuppressed(ex);
                throw ioEx;
            }
            throw ex;
        }
        return tmp;
    }

    public static void skip(DataFileStream<LogRecord> it, long count) throws IOException {
        long i;
        long blockCount;
        for (i = count; it.hasNext() && (blockCount = it.getBlockCount()) <= i; i -= blockCount) {
            it.nextBlock();
        }
        LogRecord tmp = new LogRecord();
        while (i > 0L) {
            it.next((Object)tmp);
            --i;
        }
    }

    public static long getNrLogs(Path file) throws IOException {
        SpecificDatumReader reader = new SpecificDatumReader(LogRecord.class);
        try (DataFileStream streamReader = new DataFileStream(Files.newInputStream(file, new OpenOption[0]), (DatumReader)reader);){
            long count = 0L;
            while (streamReader.hasNext()) {
                count += streamReader.getBlockCount();
                streamReader.nextBlock();
            }
            long l = count;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.sync;
        synchronized (object) {
            if (this.isStarted()) {
                try {
                    this.writer.close();
                }
                catch (IOException | RuntimeException ex) {
                    this.addError("Unable to close writer " + this.writer, ex);
                }
                finally {
                    this.writer = null;
                }
                Registry.unregister((String)"avro.log.appender", (String)this.getName());
                super.stop();
                try {
                    this.cleanup.get(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Instant now = Instant.now();
        try {
            Object object = this.sync;
            synchronized (object) {
                if (!this.isStarted()) {
                    this.ensurePartition(now);
                    Registry.export((String)"avro.log.appender", (String)this.getName(), (Object[])new Object[]{this});
                    super.start();
                }
            }
        }
        catch (IOException | InterruptedException | RuntimeException ex) {
            this.addError("Unable to ensure file partition " + now, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensurePartition(Instant instant) throws IOException, InterruptedException {
        ZonedDateTime zdt = instant.atZone(this.zoneId);
        LocalDate target = zdt.toLocalDate();
        if (target.equals(this.fileDate)) {
            return;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            finally {
                this.writer = null;
            }
        }
        this.cleanup = this.cleanup.thenRunAsync((Runnable)new AbstractRunnable(true){

            public void doRun() throws IOException {
                AvroDataFileAppender.this.cleanup();
            }
        }, DefaultExecutor.INSTANCE);
        this.fileDate = target;
        this.writer = new DataFileWriter((DatumWriter)new SpecificDatumWriter(LogRecord.class));
        if (this.codecFact != null) {
            this.writer.setCodec(this.codecFact);
        }
        String fileName = this.fileNameBase + '_' + target + ".logs.avro";
        this.currentFile = this.destinationPath.resolve(fileName);
        if (Files.isWritable(this.currentFile) && AvroDataFileAppender.isValidFile(this.currentFile)) {
            this.writer = this.writer.appendTo(this.currentFile.toFile());
        } else {
            this.writer.create(LogRecord.getClassSchema(), this.currentFile.toFile());
        }
    }

    public static boolean isValidFile(Path file) throws IOException {
        boolean valid = true;
        try {
            AvroDataFileAppender.getNrLogs(file);
        }
        catch (AvroRuntimeException ex) {
            Runtime.error((String)("Invalid log file " + file), (Throwable)ex);
            AvroDataFileAppender.rename(file);
            valid = false;
        }
        return valid;
    }

    private static void rename(Path file) throws IOException {
        Path parent = file.getParent();
        Path fileName = file.getFileName();
        if (fileName == null) {
            throw new IllegalArgumentException("invalid file path " + file);
        }
        String fileNameStr = fileName.toString();
        if (parent == null) {
            Files.move(file, Paths.get(fileNameStr + ".bad", new String[0]), new CopyOption[0]);
        } else {
            Files.move(file, parent.resolve(fileNameStr + ".bad"), new CopyOption[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent eventObject) {
        LogRecord record = Converters.convert(eventObject);
        Instant ts = record.getTs();
        Object object = this.sync;
        synchronized (object) {
            if (!this.started) {
                Runtime.error((String)("Appending to closed appender " + record));
                this.addError("Appending to closed appender " + record);
                return;
            }
            try {
                this.ensurePartition(ts);
            }
            catch (IOException | InterruptedException | RuntimeException ex) {
                Runtime.error((String)("Failed to serialize " + record), (Throwable)ex);
                this.addError("Unable to setup log file", ex);
                return;
            }
            try {
                this.writer.append((Object)record);
            }
            catch (IOException | RuntimeException ex) {
                Runtime.error((String)("Failed to serialize " + record), (Throwable)ex);
                this.addError("Unable to write log " + record, ex);
            }
        }
    }

    public String toString() {
        return "AvroDataFileAppender{fileNameBase=" + this.fileNameBase + ", writer=" + this.writer + ", fileDate=" + this.fileDate + ", currentFile=" + this.currentFile + ", destinationPath=" + this.destinationPath + ", zoneId=" + this.zoneId + '}';
    }

    private static class FileChronoComparator
    implements Comparator<Path>,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final Comparator<Path> INSTANCE = new FileChronoComparator();

        private FileChronoComparator() {
        }

        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public int compare(Path p1, Path p2) {
            return p1.getFileName().toString().compareTo(p2.getFileName().toString());
        }
    }
}

