/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import org.spf4j.log.LogbackUtils;
import org.spf4j.log.SLF4JBridgeHandler;

public final class LogbackService {
    private final String applicationName;
    private final String logFolder;
    private final String fileNameBase;
    private final String mainConfigFile;

    public LogbackService(String applicationName, String logFolder, String fileNameBase) {
        this(applicationName, logFolder, fileNameBase, "logback-avro.xml");
    }

    public LogbackService(String applicationName, String logFolder, String fileNameBase, String mainConfigFile) {
        this.applicationName = applicationName;
        this.logFolder = logFolder;
        this.fileNameBase = fileNameBase;
        this.mainConfigFile = mainConfigFile;
        System.setProperty("appName", applicationName);
        System.setProperty("logFolder", logFolder);
        System.setProperty("logFileBase", fileNameBase);
    }

    public static void redirecJDKLogging2Slf4j() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    public void start() {
        LogbackUtils.reconfigure(this.mainConfigFile);
    }

    public void stop() {
        LogbackUtils.reconfigure("logback.xml");
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getLogFolder() {
        return this.logFolder;
    }

    public String getFileNameBase() {
        return this.fileNameBase;
    }

    public String getMainConfigFile() {
        return this.mainConfigFile;
    }

    public String toString() {
        return "LogbackService{applicationName=" + this.applicationName + ", logFolder=" + this.logFolder + ", fileNameBase=" + this.fileNameBase + ", mainConfigFile=" + this.mainConfigFile + '}';
    }

    static {
        LogbackService.redirecJDKLogging2Slf4j();
    }
}

