/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.AppenderAttachable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.spf4j.log.AvroDataFileAppender;

public final class LogbackUtils {
    private LogbackUtils() {
    }

    public static Map<String, AvroDataFileAppender> getConfiguredFileAppenders() {
        HashMap<String, AvroDataFileAppender> result = new HashMap<String, AvroDataFileAppender>(4);
        LogbackUtils.configuredFileAppenders(a -> result.put(a.getName(), (AvroDataFileAppender)((Object)a)));
        return result;
    }

    public static void configuredFileAppenders(Consumer<AvroDataFileAppender> consumer) {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        if (!(iLoggerFactory instanceof LoggerContext)) {
            return;
        }
        LoggerContext context = (LoggerContext)iLoggerFactory;
        LogbackUtils.scanAppenders(context, consumer);
    }

    public static void scanAppenders(LoggerContext context, Consumer<AvroDataFileAppender> consumer) {
        for (Logger logger : context.getLoggerList()) {
            LogbackUtils.configuredFileAppenders((AppenderAttachable)logger, consumer);
        }
    }

    @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
    public static void configuredFileAppenders(AppenderAttachable aa, Consumer<AvroDataFileAppender> consumer) {
        Iterator it = aa.iteratorForAppenders();
        while (it.hasNext()) {
            Appender appender = (Appender)it.next();
            if (appender instanceof AvroDataFileAppender) {
                consumer.accept((AvroDataFileAppender)appender);
                continue;
            }
            if (!(appender instanceof AppenderAttachable)) continue;
            LogbackUtils.configuredFileAppenders((AppenderAttachable)appender, consumer);
        }
    }

    public static void reconfigure(String classPathConfigFile) {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (loggerFactory instanceof LoggerContext) {
            LoggerContext lc = (LoggerContext)loggerFactory;
            lc.reset();
            JoranConfigurator jc = new JoranConfigurator();
            jc.setContext((Context)lc);
            try (InputStream is = ClassLoader.getSystemResourceAsStream(classPathConfigFile);){
                jc.doConfigure(is);
            }
            catch (IOException ex) {
                jc.addError("Configuration failure", (Throwable)ex);
                throw new UncheckedIOException(ex);
            }
            catch (JoranException ex) {
                jc.addError("Configuration failure", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
    }
}

