/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring.mock;

import java.util.Collections;
import java.util.List;
import org.spockframework.spring.mock.MockDefinition;
import org.spockframework.spring.mock.QualifierDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.util.ObjectUtils;
import spock.mock.DetachedMockFactory;

class StubDefinition
implements MockDefinition {
    private static final DetachedMockFactory detachedMockFactory = new DetachedMockFactory();
    private final ResolvableType type;

    StubDefinition(Class<?> type) {
        this.type = ResolvableType.forClass(type);
    }

    @Override
    public Object createMock(String name) {
        return detachedMockFactory.Stub(Collections.singletonMap("name", name), this.type.getRawClass());
    }

    @Override
    public ResolvableType getTypeToMock() {
        return this.type;
    }

    @Override
    public List<String> getAliases() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public QualifierDefinition getQualifier() {
        return null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.type);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StubDefinition that = (StubDefinition)o;
        return ObjectUtils.nullSafeEquals((Object)this.type, (Object)that.type);
    }
}

